// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.translation.text.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Element containing the translated text.
 */
@Immutable
public final class TranslatedTextItem {

    /*
     * The detectedLanguage property is only present in the result object when language auto-detection is requested.
     */
    @Generated
    @JsonProperty(value = "detectedLanguage")
    private DetectedLanguage detectedLanguage;

    /*
     * An array of translation results. The size of the array matches the number of target
     * languages specified through the to query parameter.
     */
    @Generated
    @JsonProperty(value = "translations")
    private final List<TranslationText> translations;

    /*
     * Input text in the default script of the source language. sourceText property is present only when
     * the input is expressed in a script that's not the usual script for the language. For example,
     * if the input were Arabic written in Latin script, then sourceText.text would be the same Arabic text
     * converted into Arab script.
     */
    @Generated
    @JsonProperty(value = "sourceText")
    private SourceText sourceText;

    /**
     * Creates an instance of TranslatedTextItem class.
     *
     * @param translations the translations value to set.
     */
    @Generated
    @JsonCreator
    private TranslatedTextItem(@JsonProperty(value = "translations") List<TranslationText> translations) {
        this.translations = translations;
    }

    /**
     * Get the detectedLanguage property: The detectedLanguage property is only present in the result object when
     * language auto-detection is requested.
     *
     * @return the detectedLanguage value.
     */
    @Generated
    public DetectedLanguage getDetectedLanguage() {
        return this.detectedLanguage;
    }

    /**
     * Get the translations property: An array of translation results. The size of the array matches the number of
     * target
     * languages specified through the to query parameter.
     *
     * @return the translations value.
     */
    @Generated
    public List<TranslationText> getTranslations() {
        return this.translations;
    }

    /**
     * Get the sourceText property: Input text in the default script of the source language. sourceText property is
     * present only when
     * the input is expressed in a script that's not the usual script for the language. For example,
     * if the input were Arabic written in Latin script, then sourceText.text would be the same Arabic text
     * converted into Arab script.
     *
     * @return the sourceText value.
     */
    @Generated
    public SourceText getSourceText() {
        return this.sourceText;
    }
}
