// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.translation.text.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Translation result.
 */
@Immutable
public final class TranslationText {

    /*
     * A string giving the translated text.
     */
    @Generated
    @JsonProperty(value = "text")
    private final String text;

    /*
     * An object giving the translated text in the script specified by the toScript parameter.
     */
    @Generated
    @JsonProperty(value = "transliteration")
    private TransliteratedText transliteration;

    /*
     * Alignment information.
     */
    @Generated
    @JsonProperty(value = "alignment")
    private TranslatedTextAlignment alignment;

    /*
     * Sentence boundaries in the input and output texts.
     */
    @Generated
    @JsonProperty(value = "sentLen")
    private SentenceBoundaries sentenceBoundaries;

    /**
     * Creates an instance of TranslationText class.
     *
     * @param targetLanguage the targetLanguage value to set.
     * @param text the text value to set.
     */
    @Generated
    @JsonCreator
    private TranslationText(@JsonProperty(value = "to") String targetLanguage,
        @JsonProperty(value = "text") String text) {
        this.targetLanguage = targetLanguage;
        this.text = text;
    }

    /**
     * Get the targetLanguage property: A string representing the language code of the target language.
     *
     * @return the targetLanguage value.
     */
    @Generated
    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    /**
     * Get the text property: A string giving the translated text.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Get the transliteration property: An object giving the translated text in the script specified by the toScript
     * parameter.
     *
     * @return the transliteration value.
     */
    @Generated
    public TransliteratedText getTransliteration() {
        return this.transliteration;
    }

    /**
     * Get the alignment property: Alignment information.
     *
     * @return the alignment value.
     */
    @Generated
    public TranslatedTextAlignment getAlignment() {
        return this.alignment;
    }

    /**
     * Get the sentenceBoundaries property: Sentence boundaries in the input and output texts.
     *
     * @return the sentenceBoundaries value.
     */
    @Generated
    public SentenceBoundaries getSentenceBoundaries() {
        return this.sentenceBoundaries;
    }

    /*
     * A string representing the language code of the target language.
     */
    @Generated
    @JsonProperty(value = "to")
    private final String targetLanguage;
}
