// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.translation.text.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Script definition with list of script into which given script can be translitered.
 */
@Immutable
public final class TransliterableScript extends LanguageScript {

    /**
     * Creates an instance of TransliterableScript class.
     *
     * @param code the code value to set.
     * @param name the name value to set.
     * @param nativeName the nativeName value to set.
     * @param directionality the directionality value to set.
     * @param targetLanguageScripts the targetLanguageScripts value to set.
     */
    @Generated
    @JsonCreator
    private TransliterableScript(@JsonProperty(value = "code") String code, @JsonProperty(value = "name") String name,
        @JsonProperty(value = "nativeName") String nativeName,
        @JsonProperty(value = "dir") LanguageDirectionality directionality,
        @JsonProperty(value = "toScripts") List<LanguageScript> targetLanguageScripts) {
        super(code, name, nativeName, directionality);
        this.targetLanguageScripts = targetLanguageScripts;
    }

    /**
     * Get the targetLanguageScripts property: List of scripts available to convert text to.
     *
     * @return the targetLanguageScripts value.
     */
    @Generated
    public List<LanguageScript> getTargetLanguageScripts() {
        return this.targetLanguageScripts;
    }

    /*
     * List of scripts available to convert text to.
     */
    @Generated
    @JsonProperty(value = "toScripts")
    private final List<LanguageScript> targetLanguageScripts;
}
