// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.translation.text.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Transliterated text element.
 */
@Immutable
public final class TransliteratedText {

    /*
     * A string which is the result of converting the input string to the output script.
     */
    @Generated
    @JsonProperty(value = "text")
    private final String text;

    /*
     * A string specifying the script used in the output.
     */
    @Generated
    @JsonProperty(value = "script")
    private final String script;

    /**
     * Creates an instance of TransliteratedText class.
     *
     * @param text the text value to set.
     * @param script the script value to set.
     */
    @Generated
    @JsonCreator
    private TransliteratedText(@JsonProperty(value = "text") String text,
        @JsonProperty(value = "script") String script) {
        this.text = text;
        this.script = script;
    }

    /**
     * Get the text property: A string which is the result of converting the input string to the output script.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Get the script property: A string specifying the script used in the output.
     *
     * @return the script value.
     */
    @Generated
    public String getScript() {
        return this.script;
    }
}
