// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.translation.text.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The value of the transliteration property is a dictionary of (key, value) pairs.
 * Each key is a BCP 47 language tag. A key identifies a language for which text can be converted from one script
 * to another script.
 */
@Immutable
public final class TransliterationLanguage {

    /*
     * Display name of the language in the locale requested via Accept-Language header.
     */
    @Generated
    @JsonProperty(value = "name")
    private final String name;

    /*
     * Display name of the language in the locale native for this language.
     */
    @Generated
    @JsonProperty(value = "nativeName")
    private final String nativeName;

    /*
     * List of scripts to convert from.
     */
    @Generated
    @JsonProperty(value = "scripts")
    private final List<TransliterableScript> scripts;

    /**
     * Creates an instance of TransliterationLanguage class.
     *
     * @param name the name value to set.
     * @param nativeName the nativeName value to set.
     * @param scripts the scripts value to set.
     */
    @Generated
    @JsonCreator
    private TransliterationLanguage(@JsonProperty(value = "name") String name,
        @JsonProperty(value = "nativeName") String nativeName,
        @JsonProperty(value = "scripts") List<TransliterableScript> scripts) {
        this.name = name;
        this.nativeName = nativeName;
        this.scripts = scripts;
    }

    /**
     * Get the name property: Display name of the language in the locale requested via Accept-Language header.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the nativeName property: Display name of the language in the locale native for this language.
     *
     * @return the nativeName value.
     */
    @Generated
    public String getNativeName() {
        return this.nativeName;
    }

    /**
     * Get the scripts property: List of scripts to convert from.
     *
     * @return the scripts value.
     */
    @Generated
    public List<TransliterableScript> getScripts() {
        return this.scripts;
    }
}
