/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text;

import com.azure.ai.translation.text.TextTranslationClientBuilder;
import com.azure.ai.translation.text.implementation.TextTranslationClientImpl;
import com.azure.ai.translation.text.models.BreakSentenceItem;
import com.azure.ai.translation.text.models.DictionaryExampleItem;
import com.azure.ai.translation.text.models.DictionaryExampleTextItem;
import com.azure.ai.translation.text.models.DictionaryLookupItem;
import com.azure.ai.translation.text.models.GetSupportedLanguagesResult;
import com.azure.ai.translation.text.models.InputTextItem;
import com.azure.ai.translation.text.models.LanguageScope;
import com.azure.ai.translation.text.models.ProfanityAction;
import com.azure.ai.translation.text.models.ProfanityMarker;
import com.azure.ai.translation.text.models.TextType;
import com.azure.ai.translation.text.models.TranslateOptions;
import com.azure.ai.translation.text.models.TranslatedTextItem;
import com.azure.ai.translation.text.models.TransliteratedText;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.serializer.TypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@ServiceClient(builder=TextTranslationClientBuilder.class)
public final class TextTranslationClient {
    private final TextTranslationClientImpl serviceClient;
    private static final TypeReference<List<TransliteratedText>> TYPE_REFERENCE_LIST_TRANSLITERATED_TEXT = new TypeReference<List<TransliteratedText>>(){};
    private static final TypeReference<List<BreakSentenceItem>> TYPE_REFERENCE_LIST_BREAK_SENTENCE_ITEM = new TypeReference<List<BreakSentenceItem>>(){};
    private static final TypeReference<List<DictionaryLookupItem>> TYPE_REFERENCE_LIST_DICTIONARY_LOOKUP_ITEM = new TypeReference<List<DictionaryLookupItem>>(){};
    private static final TypeReference<List<DictionaryExampleItem>> TYPE_REFERENCE_LIST_DICTIONARY_EXAMPLE_ITEM = new TypeReference<List<DictionaryExampleItem>>(){};
    private static final TypeReference<List<TranslatedTextItem>> TYPE_REFERENCE_LIST_TRANSLATED_TEXT_ITEM = new TypeReference<List<TranslatedTextItem>>(){};

    TextTranslationClient(TextTranslationClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> translateWithResponse(List<String> targetLanguages, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.translateWithResponse(targetLanguages, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> transliterateWithResponse(String language, String sourceLanguageScript, String targetLanguageScript, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.transliterateWithResponse(language, sourceLanguageScript, targetLanguageScript, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> findSentenceBoundariesWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.findSentenceBoundariesWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> lookupDictionaryEntriesWithResponse(String sourceLanguage, String targetLanguage, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.lookupDictionaryEntriesWithResponse(sourceLanguage, targetLanguage, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> lookupDictionaryExamplesWithResponse(String sourceLanguage, String targetLanguage, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.lookupDictionaryExamplesWithResponse(sourceLanguage, targetLanguage, body, requestOptions);
    }

    private List<TranslatedTextItem> translate(List<String> targetLanguages, List<InputTextItem> body, String clientTraceId, String sourceLanguage, TextType textType, String category, ProfanityAction profanityAction, ProfanityMarker profanityMarker, Boolean includeAlignment, Boolean includeSentenceLength, String suggestedSourceLanguage, String sourceLanguageScript, String targetLanguageScript, Boolean allowFallback) {
        RequestOptions requestOptions = new RequestOptions();
        if (clientTraceId != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"X-ClientTraceId"), clientTraceId);
        }
        if (sourceLanguage != null) {
            requestOptions.addQueryParam("from", sourceLanguage, false);
        }
        if (textType != null) {
            requestOptions.addQueryParam("textType", textType.toString(), false);
        }
        if (category != null) {
            requestOptions.addQueryParam("category", category, false);
        }
        if (profanityAction != null) {
            requestOptions.addQueryParam("profanityAction", profanityAction.toString(), false);
        }
        if (profanityMarker != null) {
            requestOptions.addQueryParam("profanityMarker", profanityMarker.toString(), false);
        }
        if (includeAlignment != null) {
            requestOptions.addQueryParam("includeAlignment", String.valueOf(includeAlignment), false);
        }
        if (includeSentenceLength != null) {
            requestOptions.addQueryParam("includeSentenceLength", String.valueOf(includeSentenceLength), false);
        }
        if (suggestedSourceLanguage != null) {
            requestOptions.addQueryParam("suggestedFrom", suggestedSourceLanguage, false);
        }
        if (sourceLanguageScript != null) {
            requestOptions.addQueryParam("fromScript", sourceLanguageScript, false);
        }
        if (targetLanguageScript != null) {
            requestOptions.addQueryParam("toScript", targetLanguageScript, false);
        }
        if (allowFallback != null) {
            requestOptions.addQueryParam("allowFallback", String.valueOf(allowFallback), false);
        }
        return (List)((BinaryData)this.translateWithResponse(targetLanguages, BinaryData.fromObject(body), requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_TRANSLATED_TEXT_ITEM);
    }

    private List<TranslatedTextItem> translateInner(List<String> targetLanguages, List<InputTextItem> body) {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.translateWithResponse(targetLanguages, BinaryData.fromObject(body), requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_TRANSLATED_TEXT_ITEM);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<TranslatedTextItem> translate(String targetLanguage, List<String> texts) {
        return this.translateInner(Arrays.asList(targetLanguage), this.convertTextToData(texts));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TranslatedTextItem translate(String targetLanguage, String text) {
        return this.translate(targetLanguage, Arrays.asList(text)).get(0);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TranslatedTextItem translate(String text, TranslateOptions translateOptions) {
        return this.translate(Arrays.asList(text), translateOptions).get(0);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<TranslatedTextItem> translate(List<String> texts, TranslateOptions translateOptions) {
        ArrayList<InputTextItem> content = new ArrayList<InputTextItem>();
        for (String text : texts) {
            content.add(new InputTextItem(text));
        }
        return this.translate(translateOptions.getTargetLanguages(), content, translateOptions.getClientTraceId(), translateOptions.getSourceLanguage(), translateOptions.getTextType(), translateOptions.getCategory(), translateOptions.getProfanityAction(), translateOptions.getProfanityMarker(), translateOptions.isIncludeAlignment(), translateOptions.isIncludeSentenceLength(), translateOptions.getSuggestedSourceLanguage(), translateOptions.getSourceLanguageScript(), translateOptions.getTargetLanguageScript(), translateOptions.isAllowFallback());
    }

    private List<TransliteratedText> transliterateInner(String language, String sourceLanguageScript, String targetLanguageScript, List<InputTextItem> body) {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.transliterateWithResponse(language, sourceLanguageScript, targetLanguageScript, BinaryData.fromObject(body), requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_TRANSLITERATED_TEXT);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<TransliteratedText> transliterate(String language, String sourceLanguageScript, String targetLanguageScript, List<String> body) {
        return this.transliterateInner(language, sourceLanguageScript, targetLanguageScript, this.convertTextToData(body));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TransliteratedText transliterate(String language, String sourceLanguageScript, String targetLanguageScript, String text) {
        return this.transliterate(language, sourceLanguageScript, targetLanguageScript, Arrays.asList(text)).get(0);
    }

    private List<BreakSentenceItem> findSentenceBoundariesInner(List<InputTextItem> body, String language, String script) {
        RequestOptions requestOptions = new RequestOptions();
        if (language != null) {
            requestOptions.addQueryParam("language", language, false);
        }
        if (script != null) {
            requestOptions.addQueryParam("script", script, false);
        }
        return (List)((BinaryData)this.findSentenceBoundariesWithResponse(BinaryData.fromObject(body), requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_BREAK_SENTENCE_ITEM);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<BreakSentenceItem> findSentenceBoundaries(List<String> texts, String language, String script) {
        return this.findSentenceBoundariesInner(this.convertTextToData(texts), language, script);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BreakSentenceItem findSentenceBoundaries(String text, String language, String script) {
        return this.findSentenceBoundaries(Arrays.asList(text), language, script).get(0);
    }

    private List<BreakSentenceItem> findSentenceBoundariesInner(List<InputTextItem> body) {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.findSentenceBoundariesWithResponse(BinaryData.fromObject(body), requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_BREAK_SENTENCE_ITEM);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<BreakSentenceItem> findSentenceBoundaries(List<String> texts) {
        return this.findSentenceBoundariesInner(this.convertTextToData(texts));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BreakSentenceItem findSentenceBoundaries(String text) {
        return this.findSentenceBoundaries(Arrays.asList(text)).get(0);
    }

    private List<DictionaryLookupItem> lookupDictionaryEntriesInner(String sourceLanguage, String targetLanguage, List<InputTextItem> body) {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.lookupDictionaryEntriesWithResponse(sourceLanguage, targetLanguage, BinaryData.fromObject(body), requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_DICTIONARY_LOOKUP_ITEM);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<DictionaryLookupItem> lookupDictionaryEntries(String sourceLanguage, String targetLanguage, List<String> texts) {
        return this.lookupDictionaryEntriesInner(sourceLanguage, targetLanguage, this.convertTextToData(texts));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DictionaryLookupItem lookupDictionaryEntries(String sourceLanguage, String targetLanguage, String text) {
        return this.lookupDictionaryEntries(sourceLanguage, targetLanguage, Arrays.asList(text)).get(0);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<DictionaryExampleItem> lookupDictionaryExamples(String sourceLanguage, String targetLanguage, List<DictionaryExampleTextItem> body) {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.lookupDictionaryExamplesWithResponse(sourceLanguage, targetLanguage, BinaryData.fromObject(body), requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_DICTIONARY_EXAMPLE_ITEM);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getSupportedLanguagesWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getSupportedLanguagesWithResponse(requestOptions);
    }

    private GetSupportedLanguagesResult getSupportedLanguages(String scope, String acceptLanguage, String ifNoneMatch) {
        RequestOptions requestOptions = new RequestOptions();
        if (scope != null) {
            requestOptions.addQueryParam("scope", scope, false);
        }
        if (acceptLanguage != null) {
            requestOptions.setHeader(HttpHeaderName.ACCEPT_LANGUAGE, acceptLanguage);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return (GetSupportedLanguagesResult)((BinaryData)this.getSupportedLanguagesWithResponse(requestOptions).getValue()).toObject(GetSupportedLanguagesResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public GetSupportedLanguagesResult getSupportedLanguages(List<LanguageScope> scopes, String acceptLanguage, String ifNoneMatch) {
        return this.getSupportedLanguages(this.convertToScopesString(scopes), acceptLanguage, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public GetSupportedLanguagesResult getSupportedLanguages() {
        RequestOptions requestOptions = new RequestOptions();
        return (GetSupportedLanguagesResult)((BinaryData)this.getSupportedLanguagesWithResponse(requestOptions).getValue()).toObject(GetSupportedLanguagesResult.class);
    }

    private List<InputTextItem> convertTextToData(List<String> texts) {
        ArrayList<InputTextItem> content = new ArrayList<InputTextItem>();
        for (String text : texts) {
            content.add(new InputTextItem(text));
        }
        return content;
    }

    private String convertToScopesString(List<LanguageScope> scopes) {
        if (scopes == null) {
            return null;
        }
        String result = "";
        for (LanguageScope scope : scopes) {
            if (!result.isEmpty()) {
                result = result + ",";
            }
            result = result + scope.toString();
        }
        return result;
    }

    private List<DictionaryExampleItem> lookupDictionaryExamples(String sourceLanguage, String targetLanguage, List<DictionaryExampleTextItem> body, String clientTraceId) {
        RequestOptions requestOptions = new RequestOptions();
        if (clientTraceId != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"X-ClientTraceId"), clientTraceId);
        }
        return (List)((BinaryData)this.lookupDictionaryExamplesWithResponse(sourceLanguage, targetLanguage, BinaryData.fromObject(body), requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_DICTIONARY_EXAMPLE_ITEM);
    }
}

