/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.ai.translation.text.models.DetectedLanguage;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BreakSentenceItem
implements JsonSerializable<BreakSentenceItem> {
    private DetectedLanguage detectedLanguage;
    private final List<Integer> sentencesLengths;

    private BreakSentenceItem(List<Integer> sentencesLengths) {
        this.sentencesLengths = sentencesLengths;
    }

    public DetectedLanguage getDetectedLanguage() {
        return this.detectedLanguage;
    }

    public List<Integer> getSentencesLengths() {
        return this.sentencesLengths;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("sentLen", this.sentencesLengths, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeJsonField("detectedLanguage", (JsonSerializable)this.detectedLanguage);
        return jsonWriter.writeEndObject();
    }

    public static BreakSentenceItem fromJson(JsonReader jsonReader) throws IOException {
        return (BreakSentenceItem)jsonReader.readObject(reader -> {
            List sentencesLengths = null;
            DetectedLanguage detectedLanguage = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sentLen".equals(fieldName)) {
                    sentencesLengths = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                if ("detectedLanguage".equals(fieldName)) {
                    detectedLanguage = DetectedLanguage.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            BreakSentenceItem deserializedBreakSentenceItem = new BreakSentenceItem(sentencesLengths);
            deserializedBreakSentenceItem.detectedLanguage = detectedLanguage;
            return deserializedBreakSentenceItem;
        });
    }
}

