/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DetectedLanguage
implements JsonSerializable<DetectedLanguage> {
    private final String language;
    private final double confidence;

    private DetectedLanguage(String language, double confidence) {
        this.language = language;
        this.confidence = confidence;
    }

    public String getLanguage() {
        return this.language;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("language", this.language);
        jsonWriter.writeDoubleField("score", this.confidence);
        return jsonWriter.writeEndObject();
    }

    public static DetectedLanguage fromJson(JsonReader jsonReader) throws IOException {
        return (DetectedLanguage)jsonReader.readObject(reader -> {
            String language = null;
            double confidence = 0.0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("language".equals(fieldName)) {
                    language = reader.getString();
                    continue;
                }
                if ("score".equals(fieldName)) {
                    confidence = reader.getDouble();
                    continue;
                }
                reader.skipChildren();
            }
            return new DetectedLanguage(language, confidence);
        });
    }
}

