/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DictionaryExample
implements JsonSerializable<DictionaryExample> {
    private final String sourcePrefix;
    private final String sourceTerm;
    private final String sourceSuffix;
    private final String targetPrefix;
    private final String targetTerm;
    private final String targetSuffix;

    private DictionaryExample(String sourcePrefix, String sourceTerm, String sourceSuffix, String targetPrefix, String targetTerm, String targetSuffix) {
        this.sourcePrefix = sourcePrefix;
        this.sourceTerm = sourceTerm;
        this.sourceSuffix = sourceSuffix;
        this.targetPrefix = targetPrefix;
        this.targetTerm = targetTerm;
        this.targetSuffix = targetSuffix;
    }

    public String getSourcePrefix() {
        return this.sourcePrefix;
    }

    public String getSourceTerm() {
        return this.sourceTerm;
    }

    public String getSourceSuffix() {
        return this.sourceSuffix;
    }

    public String getTargetPrefix() {
        return this.targetPrefix;
    }

    public String getTargetTerm() {
        return this.targetTerm;
    }

    public String getTargetSuffix() {
        return this.targetSuffix;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourcePrefix", this.sourcePrefix);
        jsonWriter.writeStringField("sourceTerm", this.sourceTerm);
        jsonWriter.writeStringField("sourceSuffix", this.sourceSuffix);
        jsonWriter.writeStringField("targetPrefix", this.targetPrefix);
        jsonWriter.writeStringField("targetTerm", this.targetTerm);
        jsonWriter.writeStringField("targetSuffix", this.targetSuffix);
        return jsonWriter.writeEndObject();
    }

    public static DictionaryExample fromJson(JsonReader jsonReader) throws IOException {
        return (DictionaryExample)jsonReader.readObject(reader -> {
            String sourcePrefix = null;
            String sourceTerm = null;
            String sourceSuffix = null;
            String targetPrefix = null;
            String targetTerm = null;
            String targetSuffix = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourcePrefix".equals(fieldName)) {
                    sourcePrefix = reader.getString();
                    continue;
                }
                if ("sourceTerm".equals(fieldName)) {
                    sourceTerm = reader.getString();
                    continue;
                }
                if ("sourceSuffix".equals(fieldName)) {
                    sourceSuffix = reader.getString();
                    continue;
                }
                if ("targetPrefix".equals(fieldName)) {
                    targetPrefix = reader.getString();
                    continue;
                }
                if ("targetTerm".equals(fieldName)) {
                    targetTerm = reader.getString();
                    continue;
                }
                if ("targetSuffix".equals(fieldName)) {
                    targetSuffix = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new DictionaryExample(sourcePrefix, sourceTerm, sourceSuffix, targetPrefix, targetTerm, targetSuffix);
        });
    }
}

