/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.ai.translation.text.models.LanguageDirectionality;
import com.azure.ai.translation.text.models.TargetDictionaryLanguage;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class SourceDictionaryLanguage
implements JsonSerializable<SourceDictionaryLanguage> {
    private final String name;
    private final String nativeName;
    private final LanguageDirectionality directionality;
    private final List<TargetDictionaryLanguage> translations;

    private SourceDictionaryLanguage(String name, String nativeName, LanguageDirectionality directionality, List<TargetDictionaryLanguage> translations) {
        this.name = name;
        this.nativeName = nativeName;
        this.directionality = directionality;
        this.translations = translations;
    }

    public String getName() {
        return this.name;
    }

    public String getNativeName() {
        return this.nativeName;
    }

    public LanguageDirectionality getDirectionality() {
        return this.directionality;
    }

    public List<TargetDictionaryLanguage> getTranslations() {
        return this.translations;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("nativeName", this.nativeName);
        jsonWriter.writeStringField("dir", this.directionality == null ? null : this.directionality.toString());
        jsonWriter.writeArrayField("translations", this.translations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SourceDictionaryLanguage fromJson(JsonReader jsonReader) throws IOException {
        return (SourceDictionaryLanguage)jsonReader.readObject(reader -> {
            String name = null;
            String nativeName = null;
            LanguageDirectionality directionality = null;
            List translations = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("nativeName".equals(fieldName)) {
                    nativeName = reader.getString();
                    continue;
                }
                if ("dir".equals(fieldName)) {
                    directionality = LanguageDirectionality.fromString(reader.getString());
                    continue;
                }
                if ("translations".equals(fieldName)) {
                    translations = reader.readArray(reader1 -> TargetDictionaryLanguage.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new SourceDictionaryLanguage(name, nativeName, directionality, translations);
        });
    }
}

