/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.ai.translation.text.models.ProfanityAction;
import com.azure.ai.translation.text.models.ProfanityMarker;
import com.azure.ai.translation.text.models.TextType;
import java.util.ArrayList;
import java.util.List;

public final class TranslateOptions {
    private String sourceLanguage = null;
    private List<String> targetLanguages = new ArrayList<String>();
    private String clientTraceId = null;
    private TextType textType = TextType.PLAIN;
    private String category = null;
    private ProfanityAction profanityAction = ProfanityAction.NO_ACTION;
    private ProfanityMarker profanityMarker = ProfanityMarker.ASTERISK;
    private Boolean includeAlignment = false;
    private Boolean includeSentenceLength = false;
    private String suggestedSourceLanguage = null;
    private String sourceLanguageScript = null;
    private String targetLanguageScript = null;
    private Boolean allowFallback = false;

    public List<String> getTargetLanguages() {
        return this.targetLanguages;
    }

    public TranslateOptions setTargetLanguages(List<String> targetLanguages) {
        this.targetLanguages = targetLanguages;
        return this;
    }

    public TranslateOptions addTargetLanguage(String targetLanguage) {
        if (this.targetLanguages == null) {
            this.targetLanguages = new ArrayList<String>();
        }
        this.targetLanguages.add(targetLanguage);
        return this;
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public TranslateOptions setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
        return this;
    }

    public String getClientTraceId() {
        return this.clientTraceId;
    }

    public TranslateOptions setClientTraceId(String clientTraceId) {
        this.clientTraceId = clientTraceId;
        return this;
    }

    public TextType getTextType() {
        return this.textType;
    }

    public TranslateOptions setTextType(TextType textType) {
        this.textType = textType;
        return this;
    }

    public String getCategory() {
        return this.category;
    }

    public TranslateOptions setCategory(String category) {
        this.category = category;
        return this;
    }

    public ProfanityAction getProfanityAction() {
        return this.profanityAction;
    }

    public TranslateOptions setProfanityAction(ProfanityAction profanityAction) {
        this.profanityAction = profanityAction;
        return this;
    }

    public ProfanityMarker getProfanityMarker() {
        return this.profanityMarker;
    }

    public TranslateOptions setProfanityMarker(ProfanityMarker profanityMarker) {
        this.profanityMarker = profanityMarker;
        return this;
    }

    public Boolean isIncludeAlignment() {
        return this.includeAlignment;
    }

    public TranslateOptions setIncludeAlignment(Boolean includeAlignment) {
        this.includeAlignment = includeAlignment;
        return this;
    }

    public Boolean isIncludeSentenceLength() {
        return this.includeSentenceLength;
    }

    public TranslateOptions setIncludeSentenceLength(Boolean includeSentenceLength) {
        this.includeSentenceLength = includeSentenceLength;
        return this;
    }

    public String getSuggestedSourceLanguage() {
        return this.suggestedSourceLanguage;
    }

    public TranslateOptions setSuggestedSourceLanguage(String suggestedSourceLanguage) {
        this.suggestedSourceLanguage = suggestedSourceLanguage;
        return this;
    }

    public String getSourceLanguageScript() {
        return this.sourceLanguageScript;
    }

    public TranslateOptions setSourceLanguageScript(String sourceLanguageScript) {
        this.sourceLanguageScript = sourceLanguageScript;
        return this;
    }

    public String getTargetLanguageScript() {
        return this.targetLanguageScript;
    }

    public TranslateOptions setTargetLanguageScript(String targetLanguageScript) {
        this.targetLanguageScript = targetLanguageScript;
        return this;
    }

    public Boolean isAllowFallback() {
        return this.allowFallback;
    }

    public TranslateOptions setAllowFallback(Boolean allowFallback) {
        this.allowFallback = allowFallback;
        return this;
    }
}

