/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.ai.translation.text.models.SentenceBoundaries;
import com.azure.ai.translation.text.models.TranslatedTextAlignment;
import com.azure.ai.translation.text.models.TransliteratedText;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TranslationText
implements JsonSerializable<TranslationText> {
    private final String text;
    private TransliteratedText transliteration;
    private TranslatedTextAlignment alignment;
    private SentenceBoundaries sentenceBoundaries;
    private final String targetLanguage;

    private TranslationText(String targetLanguage, String text) {
        this.targetLanguage = targetLanguage;
        this.text = text;
    }

    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    public String getText() {
        return this.text;
    }

    public TransliteratedText getTransliteration() {
        return this.transliteration;
    }

    public TranslatedTextAlignment getAlignment() {
        return this.alignment;
    }

    public SentenceBoundaries getSentenceBoundaries() {
        return this.sentenceBoundaries;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("to", this.targetLanguage);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeJsonField("transliteration", (JsonSerializable)this.transliteration);
        jsonWriter.writeJsonField("alignment", (JsonSerializable)this.alignment);
        jsonWriter.writeJsonField("sentLen", (JsonSerializable)this.sentenceBoundaries);
        return jsonWriter.writeEndObject();
    }

    public static TranslationText fromJson(JsonReader jsonReader) throws IOException {
        return (TranslationText)jsonReader.readObject(reader -> {
            String targetLanguage = null;
            String text = null;
            TransliteratedText transliteration = null;
            TranslatedTextAlignment alignment = null;
            SentenceBoundaries sentenceBoundaries = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("to".equals(fieldName)) {
                    targetLanguage = reader.getString();
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("transliteration".equals(fieldName)) {
                    transliteration = TransliteratedText.fromJson(reader);
                    continue;
                }
                if ("alignment".equals(fieldName)) {
                    alignment = TranslatedTextAlignment.fromJson(reader);
                    continue;
                }
                if ("sentLen".equals(fieldName)) {
                    sentenceBoundaries = SentenceBoundaries.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            TranslationText deserializedTranslationText = new TranslationText(targetLanguage, text);
            deserializedTranslationText.transliteration = transliteration;
            deserializedTranslationText.alignment = alignment;
            deserializedTranslationText.sentenceBoundaries = sentenceBoundaries;
            return deserializedTranslationText;
        });
    }
}

