/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TransliteratedText
implements JsonSerializable<TransliteratedText> {
    private final String text;
    private final String script;

    private TransliteratedText(String text, String script) {
        this.text = text;
        this.script = script;
    }

    public String getText() {
        return this.text;
    }

    public String getScript() {
        return this.script;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("script", this.script);
        return jsonWriter.writeEndObject();
    }

    public static TransliteratedText fromJson(JsonReader jsonReader) throws IOException {
        return (TransliteratedText)jsonReader.readObject(reader -> {
            String text = null;
            String script = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("script".equals(fieldName)) {
                    script = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new TransliteratedText(text, script);
        });
    }
}

