/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common.internal.implementation;

import java.io.File;

public class Contracts {
    public static void throwIfNull(Object obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
    }

    public static void throwIfNull(long address, String message) {
        if (address == 0L) {
            throw new NullPointerException(message);
        }
    }

    public static void throwIfNullOrWhitespace(String obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        if (obj.length() == 0 || obj.trim().length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void throwIfTrue(boolean condition, String message) {
        if (condition) {
            throw new RuntimeException(message);
        }
    }

    public static void throwIfIllegalLanguage(String language, String message) {
        Contracts.throwIfNullOrWhitespace(language, message);
    }

    public static void throwIfIllegalSubscriptionKey(String subscription, String message) {
        Contracts.throwIfNullOrWhitespace(subscription, message);
    }

    public static void throwIfFileDoesNotExist(String filename, String message) {
        Contracts.throwIfNullOrWhitespace(filename, message);
        File file = new File(filename);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void throwIfDirectoryDoesNotExist(String directory, String message) {
        Contracts.throwIfNullOrWhitespace(directory, message);
        File file = new File(directory);
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void throwIfFail(long hr) {
        if (hr != 0L) {
            int error = Contracts.getErrorCode(hr);
            String message = Contracts.getErrorMessage(hr);
            if (message == "") {
                message = "Exception with an error code:" + Integer.toString(error);
            }
            Contracts.releaseErrorHandle(hr);
            throw new RuntimeException(message);
        }
    }

    public static void logErrorIfFail(long hr) {
        if (hr != 0L) {
            int error = Contracts.getErrorCode(hr);
            String message = Contracts.getErrorMessage(hr);
            if (message == "") {
                message = "Exception with an error code:" + Integer.toString(error);
            }
            Contracts.releaseErrorHandle(hr);
        }
    }

    private static final native String getErrorMessage(long var0);

    private static final native String getErrorCallStack(long var0);

    private static final native int getErrorCode(long var0);

    private static final native long releaseErrorHandle(long var0);
}

