/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common.internal.implementation;

import com.azure.ai.vision.common.internal.implementation.EventListener;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class EventSource<T> {
    private ArrayList<EventListener<T>> eventListenerClients = new ArrayList();
    private Runnable notifyConnectedOnce;
    private boolean notifyConnectedOnceFired = false;
    private AtomicInteger runCounter;

    public EventSource(AtomicInteger runCounter) {
        this.runCounter = runCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNotificationOnConnected(Runnable notifyConnectedOnce) {
        EventSource eventSource = this;
        synchronized (eventSource) {
            if (this.notifyConnectedOnceFired) {
                notifyConnectedOnce.run();
            }
            this.notifyConnectedOnce = notifyConnectedOnce;
        }
    }

    public boolean isUpdateNotificationOnConnectedFired() {
        return this.notifyConnectedOnceFired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(EventListener<T> listener) {
        EventSource eventSource = this;
        synchronized (eventSource) {
            if (!this.notifyConnectedOnceFired) {
                this.notifyConnectedOnceFired = true;
                if (this.notifyConnectedOnce != null) {
                    this.notifyConnectedOnce.run();
                }
            }
        }
        this.eventListenerClients.add(listener);
    }

    public void removeEventListener(EventListener<T> listener) {
        this.eventListenerClients.remove(listener);
    }

    public void fireEvent(Object sender, T e) {
        for (EventListener<T> a : this.eventListenerClients) {
            if (null != this.runCounter) {
                this.runCounter.incrementAndGet();
            }
            a.onEvent(sender, e);
            if (null == this.runCounter) continue;
            this.runCounter.decrementAndGet();
        }
    }
}

