/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common.internal.implementation;

import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.IntRef;
import com.azure.ai.vision.common.internal.implementation.PropertiesJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;
import java.nio.ByteBuffer;

public final class FrameJNI {
    public static SafeHandle getFramePropertiesHandle(SafeHandle frame) {
        Contracts.throwIfNull(frame, "frame");
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(FrameJNI.getFramePropertiesHandle(frame, handle));
        return new SafeHandle(handle.getValue(), PropertiesJNI::releasePropertiesHandle);
    }

    public static ByteBuffer getFrameData(SafeHandle frame) {
        Contracts.throwIfNull(frame, "frame");
        ByteBuffer buffer = FrameJNI.getFrameBuffer(frame);
        Contracts.throwIfNull(buffer, "buffer");
        return buffer;
    }

    private static final native long getFramePropertiesHandle(SafeHandle var0, IntRef var1);

    private static final native ByteBuffer getFrameBuffer(SafeHandle var0);

    static final native long releaseFrameHandle(long var0);
}

