/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common.internal.implementation;

import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.FrameJNI;
import com.azure.ai.vision.common.internal.implementation.IntRef;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;

public final class FrameReaderJNI {
    public static SafeHandle read(SafeHandle reader, long position, int stream) {
        Contracts.throwIfNull(reader, "reader");
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(FrameReaderJNI.readFrame(reader, position, stream, handle));
        return new SafeHandle(handle.getValue(), FrameJNI::releaseFrameHandle);
    }

    public static long getPosition(SafeHandle reader) {
        Contracts.throwIfNull(reader, "reader");
        IntRef size = new IntRef(0L);
        Contracts.throwIfFail(FrameReaderJNI.getFramesetSize(reader, size));
        return size.getValue();
    }

    private static final native long readFrame(SafeHandle var0, long var1, int var3, IntRef var4);

    private static final native long getFramesetSize(SafeHandle var0, IntRef var1);

    static final native long releaseFrameReaderHandle(long var0);
}

