/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common.internal.implementation;

import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.FrameReaderJNI;
import com.azure.ai.vision.common.internal.implementation.FrameWriterJNI;
import com.azure.ai.vision.common.internal.implementation.IntRef;
import com.azure.ai.vision.common.internal.implementation.PropertiesJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;

public final class FrameSourceJNI {
    public static SafeHandle createFrameSourceHandle(String optionName, String optionValue, SafeHandle format) {
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(FrameSourceJNI.createFrameSourceHandle(optionName, optionValue, format, handle));
        return new SafeHandle(handle.getValue(), FrameSourceJNI::releaseFrameSourceHandle);
    }

    public static SafeHandle getFrameSourceWriterHandle(long sourceHandle) {
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(FrameSourceJNI.getFrameSourceWriterHandle(sourceHandle, handle));
        return new SafeHandle(handle.getValue(), FrameWriterJNI::closeHandle);
    }

    public static SafeHandle getFrameSourceReaderHandle(long sourceHandle) {
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(FrameSourceJNI.getFrameSourceReaderHandle(sourceHandle, handle));
        return new SafeHandle(handle.getValue(), FrameReaderJNI::releaseFrameReaderHandle);
    }

    public static SafeHandle getFrameSourcePropertiesHandle(long sourceHandle) {
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(FrameSourceJNI.getFrameSourcePropertiesHandle(sourceHandle, handle));
        return new SafeHandle(handle.getValue(), PropertiesJNI::releasePropertiesHandle);
    }

    public static void frameSourceCloseWriter(long sourceHandle) {
        Contracts.throwIfFail(FrameSourceJNI.closeWriter(sourceHandle));
    }

    public static void frameSourceCallbackSet(long sourceHandle, Object sourceCallback) {
        Contracts.throwIfFail(FrameSourceJNI.frameSourceSetCallback(sourceHandle, sourceCallback));
    }

    private static native long createFrameSourceHandle(String var0, String var1, SafeHandle var2, IntRef var3);

    private static native long getFrameSourceWriterHandle(long var0, IntRef var2);

    private static native long getFrameSourceReaderHandle(long var0, IntRef var2);

    private static native long getFrameSourcePropertiesHandle(long var0, IntRef var2);

    private static native long closeWriter(long var0);

    private static native long frameSourceSetCallback(long var0, Object var2);

    static native long releaseFrameSourceHandle(long var0);
}

