/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common.internal.implementation;

import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.IntRef;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;
import java.nio.ByteBuffer;

public final class FrameWriterJNI {
    public static void write(SafeHandle writer, int stream, ByteBuffer data, String propName, String propValue) {
        Contracts.throwIfNull(writer, "writer");
        if (data.isDirect()) {
            Contracts.throwIfFail(FrameWriterJNI.writeFrameDirect(writer, stream, data, propName, propValue));
        } else {
            byte[] array = new byte[data.remaining()];
            data.get(array);
            Contracts.throwIfFail(FrameWriterJNI.writeFrame(writer, stream, array, propName, propValue));
        }
    }

    public static void writeWithProperties(SafeHandle writer, int stream, ByteBuffer data, SafeHandle properties) {
        Contracts.throwIfNull(writer, "writer");
        if (data.isDirect()) {
            Contracts.throwIfFail(FrameWriterJNI.writeFrameWithPropertiesDirect(writer, stream, data, properties));
        } else {
            byte[] array = new byte[data.remaining()];
            data.get(array);
            Contracts.throwIfFail(FrameWriterJNI.writeFrameWithProperties(writer, stream, array, properties));
        }
    }

    public static long getPosition(SafeHandle writer, int stream, String reserved) {
        Contracts.throwIfNull(writer, "writer");
        IntRef pos = new IntRef(0L);
        Contracts.throwIfFail(FrameWriterJNI.getPosition(writer, stream, reserved, pos));
        return pos.getValue();
    }

    public static void writeProperty(SafeHandle writer, int stream, String name, String value, long pos, String reserved) {
        Contracts.throwIfNull(writer, "writer");
        Contracts.throwIfFail(FrameWriterJNI.propertyWrite(writer, stream, name, value, pos, reserved));
    }

    public static void close(SafeHandle writer) {
        Contracts.throwIfNull(writer, "writer");
    }

    private static final native long writeFrame(SafeHandle var0, int var1, byte[] var2, String var3, String var4);

    private static final native long writeFrameDirect(SafeHandle var0, int var1, ByteBuffer var2, String var3, String var4);

    private static final native long writeFrameWithPropertiesDirect(SafeHandle var0, int var1, ByteBuffer var2, SafeHandle var3);

    private static final native long writeFrameWithProperties(SafeHandle var0, int var1, byte[] var2, SafeHandle var3);

    private static final native long getPosition(SafeHandle var0, int var1, String var2, IntRef var3);

    private static final native long propertyWrite(SafeHandle var0, int var1, String var2, String var3, long var4, String var6);

    static final native long closeHandle(long var0);
}

