/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common.internal.implementation;

import com.azure.ai.vision.common.internal.implementation.JsonPair;
import com.azure.ai.vision.common.internal.implementation.JsonValueJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;

public class JsonValue
implements AutoCloseable {
    private int item;
    private SafeHandle parserHandle;

    public JsonValue(int item, SafeHandle handle) {
        this.item = item;
        this.parserHandle = handle;
    }

    public static JsonValue Parse(String json) {
        JsonPair pair = JsonValueJNI.createParser(json);
        return new JsonValue(pair.getValue(), pair.getHandle());
    }

    public String asString() {
        return JsonValueJNI.asString(this.parserHandle, this.item);
    }

    public int asInt() {
        return JsonValueJNI.asInt(this.parserHandle, this.item);
    }

    public float asFloat() {
        return JsonValueJNI.asFloat(this.parserHandle, this.item);
    }

    public boolean asBoolean() {
        return JsonValueJNI.asBoolean(this.parserHandle, this.item);
    }

    public String asJson() {
        return JsonValueJNI.asJson(this.parserHandle, this.item);
    }

    public JsonValue get(String key) {
        int value = JsonValueJNI.getValue(this.parserHandle, this.item, 0, key);
        return new JsonValue(value, this.parserHandle);
    }

    public JsonValue get(int index) {
        int value = JsonValueJNI.getValue(this.parserHandle, this.item, index, null);
        return new JsonValue(value, this.parserHandle);
    }

    public boolean hasValue(int index) {
        return JsonValueJNI.hasValue(this.parserHandle, this.item, index, null);
    }

    public boolean hasValue(String key) {
        return JsonValueJNI.hasValue(this.parserHandle, this.item, 0, key);
    }

    public int count() {
        return JsonValueJNI.count(this.parserHandle, this.item);
    }

    @Override
    public void close() throws Exception {
        if (this.parserHandle != null) {
            this.parserHandle.close();
            this.parserHandle = null;
        }
    }
}

