/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common.internal.implementation;

import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.HandleReleaser;
import com.azure.ai.vision.common.internal.implementation.IntRef;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;

public final class LifetimeBinder
implements AutoCloseable {
    private final SafeHandle handle;
    private final LifetimeBinderRunnable releaseFunction;

    public LifetimeBinder(long handleToBind, HandleReleaser releaser) {
        this.releaseFunction = new LifetimeBinderRunnable(handleToBind, releaser);
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(LifetimeBinder.create(this.releaseFunction, handle));
        this.handle = new SafeHandle(handle.getValue(), LifetimeBinder::release);
    }

    private LifetimeBinder(SafeHandle handle, LifetimeBinderRunnable releaseFunction) {
        this.handle = handle;
        this.releaseFunction = releaseFunction;
    }

    public long getHandle() {
        return this.releaseFunction.getValue();
    }

    public LifetimeBinder clone() {
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(LifetimeBinder.clone(this.handle.getValue(), handle));
        return new LifetimeBinder(new SafeHandle(handle.getValue(), LifetimeBinder::release), this.releaseFunction);
    }

    @Override
    public void close() {
        this.handle.close();
    }

    private static native long create(LifetimeBinderRunnable var0, IntRef var1);

    private static native long release(long var0);

    private static native long clone(long var0, IntRef var2);

    private static class LifetimeBinderRunnable
    implements Runnable {
        private final long handle;
        private final HandleReleaser releaser;

        LifetimeBinderRunnable(long handle, HandleReleaser releaser) {
            this.handle = handle;
            this.releaser = releaser;
        }

        public long getValue() {
            return this.handle;
        }

        @Override
        public void run() {
            this.releaser.release(this.handle);
        }
    }
}

