/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common.internal.implementation;

import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.IntRef;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;

public final class PropertiesJNI {
    public static SafeHandle createPropertiesHandle() {
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(PropertiesJNI.corePropertiesCreateHandle(handle));
        Contracts.throwIfNull(handle, "Properties");
        return new SafeHandle(handle.getValue(), PropertiesJNI::releasePropertiesHandle);
    }

    public static String getPropertyString(SafeHandle propHandle, int id, String propertyName, String defaultValue) {
        Contracts.throwIfNull(propHandle, "Properties");
        return PropertiesJNI.corePropertiesStringGet(propHandle, id, propertyName, defaultValue);
    }

    public static void setPropertyString(SafeHandle propHandle, int id, String propertyName, String value) {
        Contracts.throwIfNull(propHandle, "Properties");
        Contracts.throwIfFail(PropertiesJNI.corePropertiesStringSet(propHandle, id, propertyName, value));
    }

    public static byte[] getPropertyBinary(SafeHandle propHandle, int id, String propertyName) {
        Contracts.throwIfNull(propHandle, "Properties");
        return PropertiesJNI.corePropertiesBinaryGet(propHandle, id, propertyName);
    }

    public static void setPropertyBinary(SafeHandle propHandle, int id, String propertyName, byte[] value) {
        Contracts.throwIfNull(propHandle, "Properties");
        Contracts.throwIfFail(PropertiesJNI.corePropertiesBinarySet(propHandle, id, propertyName, value));
    }

    public static void copyProperties(SafeHandle fromProperties, SafeHandle toProperties, String targetNameSpace) {
        Contracts.throwIfFail(PropertiesJNI.corePropertiesCopy(fromProperties, toProperties, targetNameSpace));
    }

    private static final native long corePropertiesCreateHandle(IntRef var0);

    private static final native String corePropertiesStringGet(SafeHandle var0, int var1, String var2, String var3);

    private static final native long corePropertiesStringSet(SafeHandle var0, int var1, String var2, String var3);

    private static final native byte[] corePropertiesBinaryGet(SafeHandle var0, int var1, String var2);

    private static final native long corePropertiesBinarySet(SafeHandle var0, int var1, String var2, byte[] var3);

    private static final native long corePropertiesCopy(SafeHandle var0, SafeHandle var1, String var2);

    static final native long releasePropertiesHandle(long var0);
}

