/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common.internal.implementation;

import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.IntRef;
import com.azure.ai.vision.common.internal.implementation.PropertiesJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;
import com.azure.ai.vision.common.internal.implementation.VisionResultJNI;

public final class VisionSessionJNI {
    public static SafeHandle createSessionHandle(SafeHandle createOptions, SafeHandle source) {
        Contracts.throwIfNull(createOptions, "createOptions");
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(VisionSessionJNI.createSessionHandle(createOptions, source, handle));
        return new SafeHandle(handle.getValue(), VisionSessionJNI::releaseVisionSessionHandle);
    }

    public static SafeHandle createSessionViewHandle(SafeHandle session, String viewKind, SafeHandle viewOptions) {
        Contracts.throwIfNull(session, "session");
        Contracts.throwIfNullOrWhitespace(viewKind, "viewKind");
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(VisionSessionJNI.createSessionViewHandle(session, viewKind, viewOptions, handle));
        return new SafeHandle(handle.getValue(), VisionSessionJNI::releaseVisionSessionViewHandle);
    }

    public static void sessionViewEventCallbackSet(Object object, SafeHandle sessionView, String name) {
        Contracts.throwIfNull(sessionView, "sessionView");
        Contracts.throwIfNullOrWhitespace(name, "name");
        Contracts.throwIfFail(VisionSessionJNI.sessionViewEventSetCallback(object, sessionView, name));
    }

    public static void sessionViewContinuousStart(SafeHandle sessionView, SafeHandle startOptions) {
        Contracts.throwIfNull(sessionView, "sessionView");
        Contracts.throwIfFail(VisionSessionJNI.sessionViewStartContinuous(sessionView, startOptions));
    }

    public static void sessionViewContinuousStop(SafeHandle sessionView, SafeHandle startOptions) {
        Contracts.throwIfNull(sessionView, "sessionView");
        Contracts.throwIfFail(VisionSessionJNI.sessionViewStopContinuous(sessionView, startOptions));
    }

    public static SafeHandle sessionViewSingleShotStart(SafeHandle sessionView, SafeHandle startOptions) {
        Contracts.throwIfNull(sessionView, "sessionView");
        SafeHandle result = new SafeHandle(0L, VisionResultJNI::releaseResultHandle);
        Contracts.throwIfFail(VisionSessionJNI.sessionViewStartSingleShot(sessionView, startOptions, result));
        return result;
    }

    public static void sessionViewSingleShotStop(SafeHandle sessionView, SafeHandle startOptions) {
        Contracts.throwIfNull(sessionView, "sessionView");
        Contracts.throwIfFail(VisionSessionJNI.sessionViewStopSingleShot(sessionView, startOptions));
    }

    public static SafeHandle sessionViewSendAdapterMessage(SafeHandle handle, String message, String value, SafeHandle properties, byte[] data) {
        Contracts.throwIfNull(handle, "handle");
        Contracts.throwIfNull(message, "message");
        SafeHandle result = new SafeHandle(0L, PropertiesJNI::releasePropertiesHandle);
        Contracts.throwIfFail(VisionSessionJNI.sessionViewSendEngineAdapterMessage(handle, message, value, properties, data, result));
        return result;
    }

    public static void reloadExtension() {
        VisionSessionJNI.reloadExtensionLibraries();
    }

    private static final native void reloadExtensionLibraries();

    private static final native long createSessionHandle(SafeHandle var0, SafeHandle var1, IntRef var2);

    private static final native long createSessionViewHandle(SafeHandle var0, String var1, SafeHandle var2, IntRef var3);

    private static final native long sessionViewEventSetCallback(Object var0, SafeHandle var1, String var2);

    private static final native long sessionViewStartContinuous(SafeHandle var0, SafeHandle var1);

    private static final native long sessionViewStopContinuous(SafeHandle var0, SafeHandle var1);

    private static final native long sessionViewStartSingleShot(SafeHandle var0, SafeHandle var1, SafeHandle var2);

    private static final native long sessionViewStopSingleShot(SafeHandle var0, SafeHandle var1);

    private static final native long sessionViewSendEngineAdapterMessage(SafeHandle var0, String var1, String var2, SafeHandle var3, byte[] var4, SafeHandle var5);

    private static final native long releaseVisionSessionHandle(long var0);

    private static final native long releaseVisionSessionViewHandle(long var0);
}

