/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common.internal.implementation;

import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.IntRef;
import com.azure.ai.vision.common.internal.implementation.PropertiesJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;

public final class VisionSourceJNI {
    public static SafeHandle createSourceHandle(String optionName, String optionValue, long extraHandle) {
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(VisionSourceJNI.createSourceHandle(optionName, optionValue, extraHandle, handle));
        return new SafeHandle(handle.getValue(), VisionSourceJNI::releaseVisionSourceHandle);
    }

    public static SafeHandle getSourcePropertiesHandle(SafeHandle source) {
        Contracts.throwIfNull(source, "source");
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(VisionSourceJNI.getSourcePropertiesHandle(source, handle));
        return new SafeHandle(handle.getValue(), PropertiesJNI::releasePropertiesHandle);
    }

    private static final native long createSourceHandle(String var0, String var1, long var2, IntRef var4);

    private static final native long getSourcePropertiesHandle(SafeHandle var0, IntRef var1);

    private static final native long releaseVisionSourceHandle(long var0);
}

