//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//

package com.azure.ai.vision.common;

/**
 * Represents a rectangular area inside an image.
 */
public final class BoundingBox {

    /**
     * Get the X-coordinate of the top left point of the area, in pixels.
     *
     * @return The X-coordinate of the top left point of the area, in pixels.
     */
    public final int getX() {
        return x;
    }

    /**
     * Get the Y-coordinate of the top left point of the area, in pixels.
     *
     * @return The Y-coordinate of the top left point of the area, in pixels.
     */
    public final int getY() {
        return y;
    }

    /**
     * Get the height of the area, in pixels.
     *
     * @return The height of the area, in pixels.
     */
    public final int getH() {
        return h;
    }

    /**
     * Get the width of the area, in pixels.
     *
     * @return The width of the area, in pixels.
     */
    public final int getW() {
        return w;
    }

    /**
     * String representation of the object
     *
     * @return The string representation of the object.
     */
    @Override
    public String toString() {
        return "BoundingBox{" +
            "X=" + getX() +
            ", Y=" + getY() +
            ", W=" + getW() +
            ", H=" + getH() +
            '}';
    }

    /**
     * Instantiates a new BoundingBox.
     *
     * @param x the X-coordinate of the top left point of the area, in pixels
     * @param y the Y-coordinate of the top left point of the area, in pixels
     * @param w the width of the area, in pixels
     * @param h the height of the area, in pixels
     */
    public BoundingBox(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    private final int x;
    private final int y;
    private final int h;
    private final int w;
}
