//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
package com.azure.ai.vision.common;

/**
 * Defines vision service options.
 */
final class VisionServiceOption  {

    /**
     * HttpProxyHost
     */
    public static final String HTTP_PROXY_HOST = "service.transport.http.proxy.host";

    /**
     * HttpProxyPort
     */
    public static final String HTTP_PROXY_PORT = "service.transport.http.proxy.port";

    /**
     * HttpProxyUserName
     */
    public static final String HTTP_PROXY_USERNAME = "service.transport.http.proxy.username";
    
    /**
     * HttpProxyPassword
     */
    public static final String HTTP_PROXY_PASSWORD = "service.transport.http.proxy.password";

    // Private constructor to prevent instantiation  
    private VisionServiceOption() {}  
}
