/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common;

import com.azure.ai.vision.common.FrameFormat;
import com.azure.ai.vision.common.PropertyCollection;
import com.azure.ai.vision.common.VisionServiceOptions;
import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.FrameJNI;
import com.azure.ai.vision.common.internal.implementation.PropertiesJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;
import java.nio.ByteBuffer;

public final class Frame
implements AutoCloseable {
    private ByteBuffer frameBuffer;
    private PropertyCollection propertyCollection;
    private SafeHandle frameHandle;

    public Frame(ByteBuffer buffer) {
        this.frameBuffer = buffer;
        this.propertyCollection = new PropertyCollection(PropertiesJNI.createPropertiesHandle());
    }

    public Frame(ByteBuffer buffer, FrameFormat frameFormat) {
        this.frameBuffer = buffer;
        this.propertyCollection = new PropertyCollection(PropertiesJNI.createPropertiesHandle());
        this.propertyCollection.setProperty("frame.format.pixel_format", String.valueOf(frameFormat.getFourCCAsInt()));
        this.propertyCollection.setProperty("frame.format.width", String.valueOf(frameFormat.getWidth()));
        this.propertyCollection.setProperty("frame.format.height", String.valueOf(frameFormat.getHeight()));
        this.propertyCollection.setProperty("frame.format.stride", String.valueOf(frameFormat.getStride()));
        this.propertyCollection.setProperty("frame.format.source_kind", "SourceKind_Color");
    }

    Frame(SafeHandle handle) {
        Contracts.throwIfNull((Object)handle, (String)"handle");
        this.frameHandle = handle;
        this.frameBuffer = null;
        this.propertyCollection = new PropertyCollection(FrameJNI.getFramePropertiesHandle((SafeHandle)handle));
    }

    public final PropertyCollection getProperties() {
        return this.propertyCollection;
    }

    public final ByteBuffer getData() {
        return this.frameBuffer;
    }

    @Override
    public final void close() {
        if (this.propertyCollection != null) {
            this.propertyCollection.close();
            this.propertyCollection = null;
        }
        if (this.frameHandle != null) {
            this.frameHandle.close();
            this.frameHandle = null;
        }
    }

    static {
        try {
            Class.forName(VisionServiceOptions.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

