/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common;

import com.azure.ai.vision.common.PropertyCollection;
import com.azure.ai.vision.common.VisionServiceOptions;
import com.azure.ai.vision.common.internal.implementation.FrameFormatJNI;
import com.azure.ai.vision.common.internal.implementation.PropertiesJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;

public final class FrameFormat
implements AutoCloseable {
    private SafeHandle formatHandle = null;
    private PropertyCollection propertyCollection;

    FrameFormat(SafeHandle handle) {
        this.formatHandle = handle;
        this.propertyCollection = new PropertyCollection(FrameFormatJNI.getFrameFormatPropertiesHandle((SafeHandle)handle));
    }

    public static FrameFormat createFourCCFormat(char ch1, char ch2, char ch3, char ch4, int width, int height, int stride) {
        try (SafeHandle propertiesHandle = PropertiesJNI.createPropertiesHandle();){
            PropertyCollection props = new PropertyCollection(propertiesHandle);
            try {
                props.setProperty("frame.format.width", String.valueOf(width));
                props.setProperty("frame.format.height", String.valueOf(height));
                if (stride > 0) {
                    props.setProperty("frame.format.stride", String.valueOf(stride));
                }
                String fourcc = "" + ch1 + ch2 + ch3 + ch4;
                props.setProperty("frame.format.fourcc", fourcc);
                SafeHandle formatHandle = FrameFormatJNI.createFrameFormatHandle((char)ch1, (char)ch2, (char)ch3, (char)ch4, (SafeHandle)propertiesHandle);
                FrameFormat frameFormat = new FrameFormat(formatHandle);
                props.close();
                return frameFormat;
            }
            catch (Throwable throwable) {
                try {
                    props.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static FrameFormat createRGBFormat(int bitsPerPixel, int width, int height, int stride) {
        FrameFormat format = FrameFormat.createFourCCFormat('R', 'G', 'B', ' ', width, height, stride);
        format.getProperties().setProperty("frame.format.bits.per.pixel", String.valueOf(bitsPerPixel));
        return format;
    }

    public String getFourCCAsString() {
        return this.propertyCollection.getProperty("frame.format.fourcc");
    }

    public int getFourCCAsInt() {
        String fourCCStr = this.propertyCollection.getProperty("frame.format.fourcc");
        int fourCC = FrameFormat.intFourcc(fourCCStr);
        return fourCC;
    }

    public int getHeight() {
        String height = this.propertyCollection.getProperty("frame.format.height");
        return Integer.parseInt(height);
    }

    public int getWidth() {
        String width = this.propertyCollection.getProperty("frame.format.width");
        return Integer.parseInt(width);
    }

    public int getStride() {
        String stride = this.propertyCollection.getProperty("frame.format.stride");
        return Integer.parseInt(stride);
    }

    public int getBitsPerPixel() {
        String bitsPerPixel = this.propertyCollection.getProperty("frame.format.bits.per.pixel");
        return Integer.parseInt(bitsPerPixel);
    }

    public void setBitsPerPixel(int value) {
        this.propertyCollection.setProperty("frame.format.bits.per.pixel", String.valueOf(value));
    }

    public PropertyCollection getProperties() {
        return this.propertyCollection;
    }

    public SafeHandle getHandle() {
        return this.formatHandle;
    }

    @Override
    public void close() {
        if (this.propertyCollection != null) {
            this.propertyCollection.close();
            this.propertyCollection = null;
        }
        if (this.formatHandle != null) {
            this.formatHandle.close();
            this.formatHandle = null;
        }
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    private static int intFourcc(String string) {
        byte[] b = string.getBytes();
        return FrameFormat.makeInt(b[3], b[2], b[1], b[0]);
    }

    static {
        try {
            Class.forName(VisionServiceOptions.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

