/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common;

import com.azure.ai.vision.common.Frame;
import com.azure.ai.vision.common.FrameFormat;
import com.azure.ai.vision.common.VisionServiceOptions;
import com.azure.ai.vision.common.VisionSource;
import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.FrameReaderJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;
import com.azure.ai.vision.common.internal.implementation.VisionResultJNI;

public final class FrameReader
implements AutoCloseable {
    private SafeHandle frameReaderHandle;
    private FrameFormat frameFormat;

    FrameReader(SafeHandle handle) {
        Contracts.throwIfNull((Object)handle, (String)"handle");
        this.frameReaderHandle = handle;
    }

    public static FrameReader fromVisionSource(VisionSource source) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static FrameReader fromResult(SafeHandle resultHandle) {
        Contracts.throwIfNull((Object)resultHandle, (String)"resultHandle");
        try (SafeHandle handle = VisionResultJNI.getFrameReaderHandle((SafeHandle)resultHandle);){
            FrameReader frameReader = new FrameReader(handle);
            return frameReader;
        }
    }

    public Frame readFrame(long position) {
        Contracts.throwIfNull((Object)this.frameReaderHandle, (String)"frameReaderHandle");
        SafeHandle frameHandle = FrameReaderJNI.read((SafeHandle)this.frameReaderHandle, (long)position, (int)0);
        return new Frame(frameHandle);
    }

    public FrameFormat getFrameFormat() {
        return this.frameFormat;
    }

    @Override
    public void close() {
        if (this.frameReaderHandle != null) {
            this.frameReaderHandle.close();
            this.frameReaderHandle = null;
        }
        if (this.frameFormat != null) {
            this.frameFormat.close();
            this.frameFormat = null;
        }
    }

    static {
        try {
            Class.forName(VisionServiceOptions.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

