/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common;

import com.azure.ai.vision.common.FrameFormat;
import com.azure.ai.vision.common.FrameWriter;
import com.azure.ai.vision.common.PropertyCollection;
import com.azure.ai.vision.common.VisionServiceOptions;
import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.FrameSourceJNI;
import com.azure.ai.vision.common.internal.implementation.PropertiesJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;
import java.util.function.Consumer;

public final class FrameSource
implements AutoCloseable {
    private SafeHandle frameSourceHandle;
    private Consumer<FrameSource> frameSourceConsumer;
    private final PropertyCollection properties;
    private FrameFormat frameFormat;
    private boolean disposed = false;

    FrameSource(SafeHandle handle, FrameFormat frameFormat) {
        Contracts.throwIfNull((Object)handle, (String)"handle");
        this.frameSourceHandle = handle;
        this.frameFormat = frameFormat;
        this.properties = new PropertyCollection(FrameSourceJNI.getFrameSourcePropertiesHandle((long)handle.getValue()));
    }

    FrameSource(SafeHandle handle, Consumer<FrameSource> frameSourceConsumer, FrameFormat frameFormat) {
        Contracts.throwIfNull((Object)handle, (String)"handle");
        this.frameSourceHandle = handle;
        this.frameFormat = frameFormat;
        this.frameSourceConsumer = frameSourceConsumer;
        this.properties = new PropertyCollection(FrameSourceJNI.getFrameSourcePropertiesHandle((long)handle.getValue()));
        if (frameSourceConsumer != null) {
            FrameSourceJNI.frameSourceCallbackSet((long)handle.getValue(), (Object)this);
        }
    }

    public static FrameSource fromFormat(FrameFormat format) {
        Contracts.throwIfNull((Object)format, (String)"format");
        PropertiesJNI.copyProperties((SafeHandle)format.getProperties().getHandle(), (SafeHandle)format.getProperties().getHandle(), (String)"adapter.streams.0.");
        format.getProperties().setProperty("adapter.streams.count", String.valueOf(1));
        SafeHandle handle = FrameSourceJNI.createFrameSourceHandle((String)"", (String)"", (SafeHandle)format.getHandle());
        return new FrameSource(handle, format);
    }

    public static FrameSource fromFormat(FrameFormat format, Consumer<FrameSource> frameSourceConsumer) {
        Contracts.throwIfNull((Object)format, (String)"format");
        SafeHandle handle = FrameSourceJNI.createFrameSourceHandle((String)"", (String)"", (SafeHandle)format.getHandle());
        return new FrameSource(handle, frameSourceConsumer, format);
    }

    public FrameWriter getWriter() {
        Contracts.throwIfTrue((boolean)this.disposed, (String)"disposed");
        SafeHandle writerHandle = FrameSourceJNI.getFrameSourceWriterHandle((long)this.frameSourceHandle.getValue());
        return new FrameWriter(writerHandle);
    }

    public void closeWriter() {
        Contracts.throwIfTrue((boolean)this.disposed, (String)"disposed");
        FrameSourceJNI.frameSourceCloseWriter((long)this.frameSourceHandle.getValue());
    }

    public FrameFormat getFormat() {
        Contracts.throwIfTrue((boolean)this.disposed, (String)"disposed");
        return this.frameFormat;
    }

    public long getHandle() {
        return this.frameSourceHandle.getValue();
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.properties != null) {
            this.properties.close();
        }
        if (this.frameSourceHandle != null) {
            this.frameSourceHandle.close();
        }
        this.frameFormat = null;
        this.disposed = true;
    }

    private void frameSourceCallback(long frameSourceHandle) {
        if (this.frameSourceConsumer != null) {
            this.frameSourceConsumer.accept(this);
        }
    }

    static {
        try {
            Class.forName(VisionServiceOptions.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

