/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common;

import com.azure.ai.vision.common.Frame;
import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.FrameWriterJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;
import java.nio.ByteBuffer;

public final class FrameWriter
implements AutoCloseable {
    private final SafeHandle frameWriterHandle;
    private boolean disposed;

    FrameWriter(SafeHandle handle) {
        Contracts.throwIfNull((Object)handle, (String)"handle");
        this.frameWriterHandle = handle;
    }

    public void write(ByteBuffer frame) {
        Contracts.throwIfTrue((boolean)this.disposed, (String)"disposed");
        FrameWriterJNI.writeWithProperties((SafeHandle)this.frameWriterHandle, (int)0, (ByteBuffer)frame, null);
    }

    public void write(Frame frame) {
        Contracts.throwIfTrue((boolean)this.disposed, (String)"disposed");
        if (frame != null) {
            FrameWriterJNI.writeWithProperties((SafeHandle)this.frameWriterHandle, (int)0, (ByteBuffer)frame.getData(), (SafeHandle)frame.getProperties().getHandle());
        } else {
            FrameWriterJNI.writeWithProperties((SafeHandle)this.frameWriterHandle, (int)0, null, null);
        }
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        this.frameWriterHandle.close();
        this.disposed = true;
    }
}

