/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common;

import com.azure.ai.vision.common.ImageWriter;
import com.azure.ai.vision.common.VisionServiceOptions;
import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.FrameSourceJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;

public final class ImageSourceBuffer
implements AutoCloseable {
    private SafeHandle imageSourceBufferHandle = FrameSourceJNI.createFrameSourceHandle((String)"", (String)"", null);
    private boolean disposed = false;

    public ImageWriter getWriter() {
        Contracts.throwIfTrue((boolean)this.disposed, (String)"disposed");
        SafeHandle writerHandle = FrameSourceJNI.getFrameSourceWriterHandle((long)this.imageSourceBufferHandle.getValue());
        return new ImageWriter(writerHandle);
    }

    public void closeWriter() {
        Contracts.throwIfTrue((boolean)this.disposed, (String)"disposed");
        FrameSourceJNI.frameSourceCloseWriter((long)this.imageSourceBufferHandle.getValue());
    }

    public long getHandle() {
        return this.imageSourceBufferHandle.getValue();
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.imageSourceBufferHandle != null) {
            this.imageSourceBufferHandle.close();
        }
        this.disposed = true;
    }

    static {
        try {
            Class.forName(VisionServiceOptions.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

