/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common;

import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.FrameWriterJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;
import java.nio.ByteBuffer;

public final class ImageWriter
implements AutoCloseable {
    private final SafeHandle imageWriterHandle;
    private boolean disposed;

    ImageWriter(SafeHandle handle) {
        Contracts.throwIfNull((Object)handle, (String)"handle");
        this.imageWriterHandle = handle;
    }

    public void write(ByteBuffer image) {
        Contracts.throwIfTrue((boolean)this.disposed, (String)"disposed");
        FrameWriterJNI.writeWithProperties((SafeHandle)this.imageWriterHandle, (int)0, (ByteBuffer)image, null);
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        this.imageWriterHandle.close();
        this.disposed = true;
    }
}

