/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common;

import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.PropertiesJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;

public final class PropertyCollection
implements AutoCloseable {
    private SafeHandle propertiesHandle = null;

    public PropertyCollection(SafeHandle propHandle) {
        Contracts.throwIfNull((Object)propHandle, (String)"propHandle");
        this.propertiesHandle = propHandle;
    }

    public String getProperty(String propertyName) {
        Contracts.throwIfNull((Object)this.propertiesHandle, (String)"collection");
        Contracts.throwIfNullOrWhitespace((String)propertyName, (String)"propertyName");
        return PropertiesJNI.getPropertyString((SafeHandle)this.propertiesHandle, (int)0, (String)propertyName, (String)"");
    }

    public byte[] getPropertyBinary(String propertyName) {
        Contracts.throwIfNull((Object)this.propertiesHandle, (String)"collection");
        Contracts.throwIfNullOrWhitespace((String)propertyName, (String)"propertyName");
        return PropertiesJNI.getPropertyBinary((SafeHandle)this.propertiesHandle, (int)0, (String)propertyName);
    }

    public String getProperty(String propertyName, String defaultValue) {
        Contracts.throwIfNull((Object)this.propertiesHandle, (String)"collection");
        Contracts.throwIfNullOrWhitespace((String)propertyName, (String)"propertyName");
        return PropertiesJNI.getPropertyString((SafeHandle)this.propertiesHandle, (int)0, (String)propertyName, (String)defaultValue);
    }

    public void setProperty(String propertyName, String value) {
        Contracts.throwIfNull((Object)this.propertiesHandle, (String)"collection");
        Contracts.throwIfNullOrWhitespace((String)propertyName, (String)"propertyName");
        Contracts.throwIfNull((Object)value, (String)"value");
        PropertiesJNI.setPropertyString((SafeHandle)this.propertiesHandle, (int)0, (String)propertyName, (String)value);
    }

    @Override
    public void close() {
        if (this.propertiesHandle != null) {
            this.propertiesHandle.close();
            this.propertiesHandle = null;
        }
    }

    public SafeHandle getHandle() {
        return this.propertiesHandle;
    }
}

