/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common;

import com.azure.ai.vision.common.PropertyCollection;
import com.azure.ai.vision.common.internal.implementation.PropertiesJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;
import com.azure.core.http.HttpClient;

public final class VisionServiceAdvancedOptions
implements AutoCloseable {
    private PropertyCollection propertyCollection;
    private HttpClient httpClient;

    VisionServiceAdvancedOptions() {
        SafeHandle propertiesHandle = PropertiesJNI.createPropertiesHandle();
        this.propertyCollection = new PropertyCollection(propertiesHandle);
        this.propertyCollection.setProperty("AZAC-SDK-PROGRAMMING-LANGUAGE", "Java");
    }

    public final String getHttpProxy() {
        return this.propertyCollection.getProperty("service.transport.http.proxy.host");
    }

    public final void setHttpProxy(String value) {
        this.propertyCollection.setProperty("service.transport.http.proxy.host", value);
    }

    public final int getHttpProxyPort() {
        String value = this.propertyCollection.getProperty("service.transport.http.proxy.port");
        return value.isEmpty() ? 0 : Integer.parseInt(value);
    }

    public final void setHttpProxyPort(int value) {
        this.propertyCollection.setProperty("service.transport.http.proxy.port", String.valueOf(value));
    }

    public final String getHttpProxyUserName() {
        return this.propertyCollection.getProperty("service.transport.http.proxy.username");
    }

    public final void setHttpProxyUserName(String value) {
        this.propertyCollection.setProperty("service.transport.http.proxy.username", value);
    }

    public final String getHttpProxyPassword() {
        return this.propertyCollection.getProperty("service.transport.http.proxy.password");
    }

    public final void setHttpProxyPassword(String value) {
        this.propertyCollection.setProperty("service.transport.http.proxy.password", value);
    }

    public final PropertyCollection getProperties() {
        return this.propertyCollection;
    }

    public final HttpClient getHttpClient() {
        return this.httpClient;
    }

    public final void setHttpClient(HttpClient value) {
        this.httpClient = value;
    }

    @Override
    public final void close() {
        if (this.propertyCollection != null) {
            this.propertyCollection.close();
            this.propertyCollection = null;
        }
    }
}

