/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common;

import com.azure.ai.vision.common.VisionServiceAdvancedOptions;
import com.azure.ai.vision.common.implementation.NativeLibraryLoader;
import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.VisionServiceOptionsJNI;
import com.azure.core.credential.TokenCredential;
import java.net.URL;

public final class VisionServiceOptions
implements AutoCloseable {
    static Class<?> visionServiceOptionsClass = null;
    private VisionServiceAdvancedOptions advancedOptions = null;
    private boolean disposed = false;
    private TokenCredential tokenCredential;

    public VisionServiceOptions(URL url) {
        Contracts.throwIfNull((Object)url, (String)"url");
        this.advancedOptions = new VisionServiceAdvancedOptions();
        this.advancedOptions.getProperties().setProperty("service.endpoint", url.toString());
    }

    public VisionServiceOptions(URL url, VisionServiceAdvancedOptions options) {
        Contracts.throwIfNull((Object)url, (String)"url");
        Contracts.throwIfNull((Object)options, (String)"options");
        this.advancedOptions = options;
        this.advancedOptions.getProperties().setProperty("service.endpoint", url.toString());
    }

    public VisionServiceOptions(URL url, String key) {
        Contracts.throwIfNull((Object)url, (String)"url");
        Contracts.throwIfNullOrWhitespace((String)key, (String)"key");
        this.advancedOptions = new VisionServiceAdvancedOptions();
        this.advancedOptions.getProperties().setProperty("service.endpoint", url.toString());
        this.advancedOptions.getProperties().setProperty("service.auth.key", key);
    }

    public VisionServiceOptions(URL url, String key, VisionServiceAdvancedOptions options) {
        Contracts.throwIfNull((Object)url, (String)"url");
        Contracts.throwIfNullOrWhitespace((String)key, (String)"key");
        Contracts.throwIfNull((Object)options, (String)"options");
        this.advancedOptions = options;
        this.advancedOptions.getProperties().setProperty("service.endpoint", url.toString());
        this.advancedOptions.getProperties().setProperty("service.auth.key", key);
    }

    public VisionServiceOptions(URL url, TokenCredential credential) {
        Contracts.throwIfNull((Object)url, (String)"url");
        Contracts.throwIfNull((Object)credential, (String)"credential");
        this.tokenCredential = credential;
        this.advancedOptions = new VisionServiceAdvancedOptions();
        this.advancedOptions.getProperties().setProperty("service.endpoint", url.toString());
    }

    public VisionServiceOptions(URL url, TokenCredential credential, VisionServiceAdvancedOptions options) {
        Contracts.throwIfNull((Object)url, (String)"url");
        Contracts.throwIfNull((Object)credential, (String)"credential");
        Contracts.throwIfNull((Object)options, (String)"options");
        this.tokenCredential = credential;
        this.advancedOptions = options;
        this.advancedOptions.getProperties().setProperty("service.endpoint", url.toString());
    }

    public final TokenCredential getTokenCredential() {
        return this.tokenCredential;
    }

    public final void setTokenCredential(TokenCredential value) {
        this.tokenCredential = value;
    }

    public final VisionServiceAdvancedOptions getAdvanced() {
        return this.advancedOptions;
    }

    @Override
    public final void close() {
        if (this.disposed) {
            return;
        }
        if (this.advancedOptions != null) {
            this.advancedOptions.close();
            this.advancedOptions = null;
        }
        this.disposed = true;
    }

    static {
        try {
            NativeLibraryLoader loader = new NativeLibraryLoader();
            loader.loadNativeBinding();
        }
        catch (Error ex) {
            throw new UnsatisfiedLinkError(String.format("Could not load a required Vision SDK library because of the following error: %s", ex.getMessage()));
        }
        catch (Exception ex2) {
            throw new UnsatisfiedLinkError(String.format("Could not load a required Vision SDK library because of the following error: %s", ex2.getMessage()));
        }
        VisionServiceOptionsJNI.setTempDir((String)System.getProperty("java.io.tmpdir"));
        visionServiceOptionsClass = VisionServiceOptions.class;
    }
}

