/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common;

import com.azure.ai.vision.common.FrameSource;
import com.azure.ai.vision.common.ImageSourceBuffer;
import com.azure.ai.vision.common.PropertyCollection;
import com.azure.ai.vision.common.VisionServiceOptions;
import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;
import com.azure.ai.vision.common.internal.implementation.VisionSourceJNI;
import java.net.URL;

public final class VisionSource
implements AutoCloseable {
    private SafeHandle visionSourceHandle;
    private PropertyCollection propertyCollection;

    VisionSource(SafeHandle handle) {
        this.visionSourceHandle = handle;
        this.propertyCollection = new PropertyCollection(VisionSourceJNI.getSourcePropertiesHandle((SafeHandle)handle));
    }

    public static VisionSource fromImageSourceBuffer(ImageSourceBuffer source) {
        Contracts.throwIfNull((Object)source, (String)"source");
        SafeHandle handle = VisionSourceJNI.createSourceHandle((String)"", (String)"", (long)source.getHandle());
        return new VisionSource(handle);
    }

    public static VisionSource fromFrameSource(FrameSource source) {
        Contracts.throwIfNull((Object)source, (String)"source");
        SafeHandle handle = VisionSourceJNI.createSourceHandle((String)"", (String)"", (long)source.getHandle());
        return new VisionSource(handle);
    }

    public static VisionSource fromFile(String filePath) {
        SafeHandle handle = VisionSourceJNI.createSourceHandle((String)"source.file.name", (String)filePath, (long)0L);
        return new VisionSource(handle);
    }

    public static VisionSource fromUrl(URL url) {
        SafeHandle handle = VisionSourceJNI.createSourceHandle((String)"source.url.name", (String)url.toString(), (long)0L);
        return new VisionSource(handle);
    }

    public final PropertyCollection getProperties() {
        return this.propertyCollection;
    }

    public final SafeHandle getHandle() {
        return this.visionSourceHandle;
    }

    @Override
    public final void close() {
        if (this.propertyCollection != null) {
            this.propertyCollection.close();
            this.propertyCollection = null;
        }
        if (this.visionSourceHandle != null) {
            this.visionSourceHandle.close();
            this.visionSourceHandle = null;
        }
    }

    static {
        try {
            Class.forName(VisionServiceOptions.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

