/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common.implementation;

import com.azure.ai.vision.common.VisionServiceOptions;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class NativeLibraryLoader {
    protected static String operatingSystem;
    private static String tempDirPrefix;
    private NativeLibrary[] nativeList = new NativeLibrary[0];
    private static File tempDir;
    private static Boolean loaded;
    private static final String lockFileExtension = ".lock";
    private static Boolean loadAll;

    public void loadNativeBinding() throws UnsatisfiedLinkError {
        try {
            if (!loaded.booleanValue()) {
                this.extractNativeLibraries();
                this.loadExtractedNativeLibraries();
            }
        }
        catch (Exception e) {
            throw new UnsatisfiedLinkError(String.format("Could not extract/load all Vision SDK libraries because we encountered the following error: %s", e.getMessage()));
        }
        finally {
            loaded = true;
        }
    }

    protected void loadExtractedNativeLibraries() throws IOException, UnsatisfiedLinkError {
        for (int i = 0; i < this.nativeList.length; ++i) {
            if (!loadAll.booleanValue() && i != this.nativeList.length - 1) continue;
            String libName = this.nativeList[i].getName();
            String fullPathName = new File(tempDir.getCanonicalPath(), libName).getCanonicalPath();
            if (!fullPathName.startsWith(tempDir.getCanonicalPath())) {
                throw new SecurityException("illegal path");
            }
            try {
                System.load(fullPathName);
                continue;
            }
            catch (UnsatisfiedLinkError e) {
                if (!this.nativeList[i].getRequired()) continue;
                throw new UnsatisfiedLinkError(String.format("Could not load a required Vision SDK library because of the following error: %s", e.getMessage()));
            }
        }
    }

    private void extractNativeLibraries() throws Exception {
        for (NativeLibrary library : this.nativeList = this.getResourceLines()) {
            String prefix = this.getResourcesPath();
            String path = prefix + library.getName();
            this.extractResourceFromPath(library, VisionServiceOptions.class.getResourceAsStream(path));
        }
    }

    private NativeLibrary[] getResourceLines() {
        if (operatingSystem.contains("linux")) {
            return new NativeLibrary[]{new NativeLibrary("libAzure-AI-Vision-Native.so", true), new NativeLibrary("libAzure-AI-Vision-JNI.so", true)};
        }
        if (operatingSystem.contains("windows")) {
            return new NativeLibrary[]{new NativeLibrary("Azure-AI-Vision-Native.dll", true), new NativeLibrary("Azure-AI-Vision-JNI.dll", true)};
        }
        if (operatingSystem.contains("mac") || operatingSystem.contains("darwin")) {
            return new NativeLibrary[]{new NativeLibrary("libAzure-AI-Vision-Native.dylib", true), new NativeLibrary("libAzure-AI-Vision-JNI.dylib", true)};
        }
        return new NativeLibrary[0];
    }

    protected String getResourcesPath() throws UnsatisfiedLinkError {
        String speechPrefix = "/ASSETS/%s%s/";
        String dataModelSize = System.getProperty("sun.arch.data.model");
        dataModelSize = dataModelSize != null && dataModelSize.equals("64") ? "64" : "32";
        if (operatingSystem.contains("linux")) {
            String osArchitecture = System.getProperty("os.arch");
            if (osArchitecture.contains("aarch64") || osArchitecture.contains("arm")) {
                return String.format(speechPrefix, "linux-arm", dataModelSize);
            }
            if (osArchitecture.contains("amd64") || osArchitecture.contains("x86_64")) {
                return String.format(speechPrefix, "linux-x", dataModelSize);
            }
        } else {
            if (operatingSystem.contains("windows")) {
                loadAll = true;
                return String.format(speechPrefix, "windows-x", dataModelSize);
            }
            if (operatingSystem.contains("mac") || operatingSystem.contains("darwin")) {
                String osArchitecture = System.getProperty("os.arch");
                if (osArchitecture.contains("aarch64") || osArchitecture.contains("arm")) {
                    return String.format(speechPrefix, "osx-arm", dataModelSize);
                }
                if (osArchitecture.contains("amd64") || osArchitecture.contains("x86_64")) {
                    return String.format(speechPrefix, "osx-x", dataModelSize);
                }
            }
        }
        throw new UnsatisfiedLinkError(String.format("The Vision SDK doesn't currently have native support for operating system: %s data model size %s", operatingSystem, dataModelSize));
    }

    protected void extractResourceFromPath(NativeLibrary library, InputStream inputStream) throws IOException {
        String libName = library.getName();
        File temp = new File(tempDir.getCanonicalPath(), libName);
        if (!temp.getCanonicalPath().startsWith(tempDir.getCanonicalPath())) {
            throw new SecurityException("illegal name " + temp.getCanonicalPath());
        }
        temp.createNewFile();
        temp.deleteOnExit();
        if (!temp.exists()) {
            throw new FileNotFoundException(String.format("Temporary file %s could not be created. Make sure you can write to this location.", temp.getCanonicalPath()));
        }
        InputStream inStream = inputStream;
        if (inStream == null) {
            if (library.getRequired()) {
                throw new FileNotFoundException(String.format("Could not find resources for %s in jar.", libName));
            }
            return;
        }
        FileOutputStream outStream = null;
        byte[] buffer = new byte[0x100000];
        try {
            int bytesRead;
            outStream = new FileOutputStream(temp);
            while ((bytesRead = inStream.read(buffer)) >= 0) {
                outStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new IOException(String.format("Could not write to temporary file %s.", temp.getCanonicalPath()), e);
        }
        finally {
            this.safeClose(outStream);
            this.safeClose(inStream);
        }
    }

    private void safeClose(Closeable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        tempDirPrefix = "vision-sdk-common-native-";
        loaded = false;
        loadAll = false;
        operatingSystem = ("" + System.getProperty("os.name")).toLowerCase();
        try {
            if (operatingSystem.contains("windows")) {
                File lockFile = Files.createTempFile(tempDirPrefix, lockFileExtension, new FileAttribute[0]).toFile();
                lockFile.createNewFile();
                lockFile.deleteOnExit();
                String tempDirName = lockFile.getAbsolutePath();
                tempDirName = tempDirName.substring(0, tempDirName.length() - lockFileExtension.length());
                tempDir = Files.createDirectory(Paths.get(tempDirName, new String[0]), new FileAttribute[0]).toFile();
                tempDir.deleteOnExit();
                Thread thread = new Thread(new DeleteUnlockedTempFolders());
                thread.start();
            } else {
                tempDir = Files.createTempDirectory(tempDirPrefix, new FileAttribute[0]).toFile();
                tempDir.deleteOnExit();
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private static class DeleteUnlockedTempFolders
    implements Runnable {
        private DeleteUnlockedTempFolders() {
        }

        @Override
        public void run() {
            FileFilter tmpDirFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().startsWith(tempDirPrefix) && !pathname.getName().endsWith(NativeLibraryLoader.lockFileExtension);
                }
            };
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            File[] filteredDirList = tmpDir.listFiles(tmpDirFilter);
            for (int i = 0; i < filteredDirList.length; ++i) {
                File lockFile = new File(filteredDirList[i].getAbsolutePath() + NativeLibraryLoader.lockFileExtension);
                if (lockFile.exists()) continue;
                try {
                    Files.walkFileTree(Paths.get(filteredDirList[i].getAbsolutePath(), new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                filteredDirList[i].delete();
            }
        }
    }

    protected final class NativeLibrary {
        private String name;
        private boolean required;

        public NativeLibrary(String name, boolean required) {
            this.name = name;
            this.required = required;
        }

        public String getName() {
            return this.name;
        }

        public boolean getRequired() {
            return this.required;
        }
    }
}

