/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.common.implementation;

import com.azure.ai.vision.common.Diagnostics;
import com.azure.ai.vision.common.PropertyCollection;
import com.azure.ai.vision.common.internal.implementation.PropertiesJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;
import com.azure.ai.vision.common.internal.implementation.VisionEventArgsJNI;
import com.azure.ai.vision.common.internal.implementation.VisionResultJNI;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.Context;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import reactor.core.publisher.Mono;

public final class SessionUtils {
    public static void SendHttpRequest(SafeHandle eventArgHandle, HttpClient client) {
        try (SafeHandle resultHandle = VisionEventArgsJNI.getResultHandle((SafeHandle)eventArgHandle);
             SafeHandle responsePropertiesHandle = VisionResultJNI.getPropertiesHandle((SafeHandle)resultHandle);
             SafeHandle requestPropertiesHandle = VisionEventArgsJNI.getPropertiesHandle((SafeHandle)eventArgHandle);
             PropertyCollection responseProperties = new PropertyCollection(responsePropertiesHandle);
             PropertyCollection requestProperties = new PropertyCollection(requestPropertiesHandle);){
            String[] headers;
            String methodStr = requestProperties.getProperty("service.transport.http.request.method");
            HttpMethod method = HttpMethod.valueOf((String)methodStr);
            String uri = requestProperties.getProperty("service.transport.http.request.uri");
            HttpRequest request = new HttpRequest(method, uri);
            String allHeaders = requestProperties.getProperty("service.transport.http.request.headers");
            for (String oneHeader : headers = allHeaders.split("\n")) {
                String headerValue = requestProperties.getProperty("service.transport.http.request.headers." + oneHeader);
                request.setHeader(oneHeader, headerValue);
            }
            byte[] content = PropertiesJNI.getPropertyBinary((SafeHandle)requestPropertiesHandle, (int)0, (String)"service.transport.http.request.content");
            if (content != null) {
                request.setBody(content);
            }
            String endpointTimeoutSeconds = requestProperties.getProperty("service.endpoint.timeoutseconds", "60");
            int timeout = Integer.parseInt(endpointTimeoutSeconds);
            SessionUtils.send(request, client, responseProperties, responsePropertiesHandle, timeout);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void send(HttpRequest request, HttpClient client, PropertyCollection responseProperties, SafeHandle responsePropertiesHandle, int timeout) {
        try {
            Mono responseMono = client.send(request, Context.NONE);
            HttpResponse response = (HttpResponse)responseMono.timeout(Duration.ofSeconds(timeout)).block();
            int statusCode = response.getStatusCode();
            responseProperties.setProperty("service.transport.http.response.status", String.valueOf(statusCode));
            String responseHeaders = "";
            for (HttpHeader header : response.getHeaders()) {
                responseHeaders = responseHeaders + header.getName() + "\n";
                responseProperties.setProperty("service.transport.http.response.headers." + header.getName(), header.getValue());
            }
            responseProperties.setProperty("service.transport.http.response.headers", responseHeaders);
            byte[] responseContent = (byte[])response.getBodyAsByteArray().block();
            PropertiesJNI.setPropertyBinary((SafeHandle)responsePropertiesHandle, (int)0, (String)"service.transport.http.response.content", (byte[])responseContent);
        }
        catch (Exception e) {
            if (e instanceof TimeoutException) {
                Diagnostics.logMessage("SendHttpRequest exception: Timeout waiting for response.");
                PropertiesJNI.setPropertyString((SafeHandle)responsePropertiesHandle, (int)0, (String)"service.transport.http.response.exception", (String)"Timeout waiting for response.");
            }
            Diagnostics.logMessage("SendHttpRequest exception: " + e.getLocalizedMessage());
            PropertiesJNI.setPropertyString((SafeHandle)responsePropertiesHandle, (int)0, (String)"service.transport.http.response.exception", (String)e.getLocalizedMessage());
        }
    }
}

