/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis;

import com.azure.ai.vision.common.PropertyCollection;
import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.imageanalysis.ImageAnalysisErrorReason;
import com.azure.ai.vision.imageanalysis.ImageAnalysisResult;
import com.azure.ai.vision.imageanalysis.ImageAnalysisResultReason;

public final class ImageAnalysisErrorDetails {
    private PropertyCollection propertyCollection;
    private String message;
    private String errorCode;
    private ImageAnalysisErrorReason reason;

    ImageAnalysisErrorDetails(ImageAnalysisResult result) {
        this.propertyCollection = result.getProperties();
        this.message = this.propertyCollection.getProperty("error.message", "");
        this.errorCode = this.propertyCollection.getProperty("error.code", "");
        int reason = Integer.parseInt(this.propertyCollection.getProperty("error.reason", "0"));
        this.reason = ImageAnalysisErrorReason.values()[reason];
    }

    public static ImageAnalysisErrorDetails fromResult(ImageAnalysisResult result) {
        Contracts.throwIfNull((Object)result, (String)"result");
        if (result.getReason() != ImageAnalysisResultReason.ERROR) {
            return null;
        }
        return new ImageAnalysisErrorDetails(result);
    }

    public final String getMessage() {
        return this.message;
    }

    public final String getErrorCode() {
        return this.errorCode;
    }

    public final ImageAnalysisErrorReason getReason() {
        return this.reason;
    }

    public String toString() {
        return "ImageAnalysisErrorDetails{message=" + this.message + ", errorCode=" + this.errorCode + ", reason=" + (Object)((Object)this.reason) + '}';
    }
}

