/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis;

import com.azure.ai.vision.common.PropertyCollection;
import com.azure.ai.vision.common.VisionServiceOptions;
import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.PropertiesJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;
import com.azure.ai.vision.imageanalysis.ImageAnalysisFeature;
import com.azure.ai.vision.imageanalysis.ImageSegmentationMode;
import com.azure.ai.vision.imageanalysis.implementation.ImageNativeLibraryLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ImageAnalysisOptions
implements AutoCloseable {
    private static final Map<ImageAnalysisFeature, String> featureTextMap = new HashMap<ImageAnalysisFeature, String>();
    private static final Map<ImageSegmentationMode, String> segmentationTextMap = new HashMap<ImageSegmentationMode, String>();
    static Class<?> imageAnalysisOptionsClass = null;
    private PropertyCollection propertyCollection;

    public ImageAnalysisOptions() {
        SafeHandle propertiesHandle = PropertiesJNI.createPropertiesHandle();
        this.propertyCollection = new PropertyCollection(propertiesHandle);
        this.propertyCollection.setProperty("adapter.passthrough", "true");
    }

    public String getLanguage() {
        return this.propertyCollection.getProperty("image.analysis.option.language", "en");
    }

    public void setLanguage(String language) {
        Contracts.throwIfNullOrWhitespace((String)language, (String)"language");
        this.propertyCollection.setProperty("image.analysis.option.language", language);
    }

    public Boolean getGenderNeutralCaption() {
        String genderString = this.propertyCollection.getProperty("image.analysis.option.genderneutralcaption", "false");
        return genderString.equals("true");
    }

    public void setGenderNeutralCaption(Boolean genderNeutralCaption) {
        Contracts.throwIfNull((Object)genderNeutralCaption, (String)"genderNeutralCaption");
        this.propertyCollection.setProperty("image.analysis.option.genderneutralcaption", genderNeutralCaption != false ? "true" : "false");
    }

    public String getModelVersion() {
        return this.propertyCollection.getProperty("image.analysis.option.modelversion", "latest");
    }

    public void setModelVersion(String modelVersion) {
        Contracts.throwIfNullOrWhitespace((String)modelVersion, (String)"modelVersion");
        this.propertyCollection.setProperty("image.analysis.option.modelversion", modelVersion);
    }

    public String getModelName() {
        return this.propertyCollection.getProperty("image.analysis.option.modelname", "");
    }

    public void setModelName(String modelName) {
        Contracts.throwIfNullOrWhitespace((String)modelName, (String)"modelName");
        this.propertyCollection.setProperty("image.analysis.option.modelname", modelName);
    }

    public EnumSet<ImageAnalysisFeature> getFeatures() {
        EnumSet<ImageAnalysisFeature> featureValues = EnumSet.noneOf(ImageAnalysisFeature.class);
        String selectedFeaturesCommaSeparated = this.propertyCollection.getProperty("image.analysis.option.visualfeatures", "");
        List<String> valuesList = Arrays.asList(selectedFeaturesCommaSeparated.split(","));
        for (Map.Entry<ImageAnalysisFeature, String> set : featureTextMap.entrySet()) {
            if (!valuesList.contains(set.getValue())) continue;
            featureValues.add(set.getKey());
        }
        return featureValues;
    }

    public void setFeatures(EnumSet<ImageAnalysisFeature> features) {
        Contracts.throwIfNull(features, (String)"features");
        String selectedFeaturesCommaSeparated = "";
        for (Map.Entry<ImageAnalysisFeature, String> set : featureTextMap.entrySet()) {
            if (!features.contains((Object)set.getKey())) continue;
            selectedFeaturesCommaSeparated = selectedFeaturesCommaSeparated + set.getValue() + ",";
        }
        if (!selectedFeaturesCommaSeparated.isEmpty()) {
            selectedFeaturesCommaSeparated = selectedFeaturesCommaSeparated.substring(0, selectedFeaturesCommaSeparated.length() - 1);
            this.propertyCollection.setProperty("image.analysis.option.visualfeatures", selectedFeaturesCommaSeparated);
        }
    }

    public List<Double> getCroppingAspectRatios() {
        String aspectRatiosCommaSeparated = this.propertyCollection.getProperty("image.analysis.option.croppingaspectratios", "");
        ArrayList<Double> aspectRatios = new ArrayList<Double>();
        if (!aspectRatiosCommaSeparated.isEmpty()) {
            List<String> aspectRatiosStringList = Arrays.asList(aspectRatiosCommaSeparated.split(","));
            for (String s : aspectRatiosStringList) {
                aspectRatios.add(Double.valueOf(s));
            }
        }
        return aspectRatios;
    }

    public void setCroppingAspectRatios(List<Double> aspectRatios) {
        Contracts.throwIfNull(aspectRatios, (String)"aspectRatios");
        ArrayList<String> aspectRatiosStringList = new ArrayList<String>();
        for (Double d : aspectRatios) {
            aspectRatiosStringList.add(String.valueOf(d));
        }
        String aspectRatiosCommaSeparated = String.join((CharSequence)",", aspectRatiosStringList);
        this.propertyCollection.setProperty("image.analysis.option.croppingaspectratios", aspectRatiosCommaSeparated);
    }

    public ImageSegmentationMode getSegmentationMode() {
        String segmentationMode = this.propertyCollection.getProperty("image.analysis.option.segmentationmode", "");
        for (Map.Entry<ImageSegmentationMode, String> set : segmentationTextMap.entrySet()) {
            if (!set.getValue().equals(segmentationMode)) continue;
            return set.getKey();
        }
        return ImageSegmentationMode.NONE;
    }

    public void setSegmentationMode(ImageSegmentationMode segmentationMode) {
        Contracts.throwIfNull((Object)((Object)segmentationMode), (String)"segmentationMode");
        this.propertyCollection.setProperty("image.analysis.option.segmentationmode", segmentationTextMap.get((Object)segmentationMode));
    }

    public final PropertyCollection getProperties() {
        return this.propertyCollection;
    }

    @Override
    public void close() throws Exception {
        if (this.propertyCollection != null) {
            this.propertyCollection.close();
            this.propertyCollection = null;
        }
    }

    static {
        try {
            try {
                Class.forName(VisionServiceOptions.class.getName());
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
            ImageNativeLibraryLoader loader = new ImageNativeLibraryLoader();
            loader.loadNativeBinding();
        }
        catch (Error ex) {
            System.err.println("Failed to load native library. " + ex.getMessage());
            throw ex;
        }
        imageAnalysisOptionsClass = ImageAnalysisOptions.class;
        featureTextMap.put(ImageAnalysisFeature.TAGS, "tags");
        featureTextMap.put(ImageAnalysisFeature.CAPTION, "caption");
        featureTextMap.put(ImageAnalysisFeature.DENSE_CAPTIONS, "denseCaptions");
        featureTextMap.put(ImageAnalysisFeature.OBJECTS, "objects");
        featureTextMap.put(ImageAnalysisFeature.PEOPLE, "people");
        featureTextMap.put(ImageAnalysisFeature.TEXT, "read");
        featureTextMap.put(ImageAnalysisFeature.CROP_SUGGESTIONS, "smartCrops");
        segmentationTextMap.put(ImageSegmentationMode.NONE, "");
        segmentationTextMap.put(ImageSegmentationMode.BACKGROUND_REMOVAL, "backgroundRemoval");
        segmentationTextMap.put(ImageSegmentationMode.FOREGROUND_MATTING, "foregroundMatting");
    }
}

