/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis;

import com.azure.ai.vision.common.BoundingBox;
import com.azure.ai.vision.common.PropertyCollection;
import com.azure.ai.vision.common.internal.implementation.JsonValue;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;
import com.azure.ai.vision.common.internal.implementation.VisionResultJNI;
import com.azure.ai.vision.imageanalysis.ContentCaption;
import com.azure.ai.vision.imageanalysis.ContentTag;
import com.azure.ai.vision.imageanalysis.CropSuggestion;
import com.azure.ai.vision.imageanalysis.DetectedObject;
import com.azure.ai.vision.imageanalysis.DetectedPerson;
import com.azure.ai.vision.imageanalysis.DetectedTextLine;
import com.azure.ai.vision.imageanalysis.DetectedTextWord;
import com.azure.ai.vision.imageanalysis.ImageAnalysisResultReason;
import com.azure.ai.vision.imageanalysis.SegmentationResult;
import java.util.ArrayList;
import java.util.List;

public final class ImageAnalysisResult
implements AutoCloseable {
    private PropertyCollection propertyCollection;
    private String jsonResult;
    private String modelVersion;
    private int imageHeight;
    private int imageWidth;
    private ContentCaption caption;
    private List<ContentCaption> denseCaptions;
    private List<ContentTag> tags;
    private List<ContentTag> customTags;
    private List<DetectedObject> detectedObjects;
    private List<DetectedObject> customObjects;
    private List<DetectedPerson> detectedPeople;
    private List<DetectedTextLine> detectedText;
    private List<CropSuggestion> cropSuggestions;
    private SegmentationResult segmentationResult;
    private SafeHandle resultHandle;

    ImageAnalysisResult(SafeHandle resultHandle) {
        block37: {
            this.resultHandle = resultHandle;
            this.propertyCollection = new PropertyCollection(VisionResultJNI.getPropertiesHandle((SafeHandle)resultHandle));
            this.jsonResult = this.propertyCollection.getProperty("image.analysis.result.json", "");
            this.tags = new ArrayList<ContentTag>();
            this.customTags = new ArrayList<ContentTag>();
            this.detectedObjects = new ArrayList<DetectedObject>();
            this.customObjects = new ArrayList<DetectedObject>();
            this.caption = new ContentCaption("", Float.valueOf(0.0f), new BoundingBox(0, 0, 0, 0));
            this.denseCaptions = new ArrayList<ContentCaption>();
            this.detectedPeople = new ArrayList<DetectedPerson>();
            this.detectedText = new ArrayList<DetectedTextLine>();
            this.cropSuggestions = new ArrayList<CropSuggestion>();
            this.segmentationResult = null;
            if (this.getReason() == ImageAnalysisResultReason.ANALYZED && !this.jsonResult.isEmpty()) {
                try (JsonValue resultRoot = JsonValue.Parse((String)this.jsonResult);){
                    JsonValue objectsResult;
                    JsonValue tagsResult;
                    JsonValue cropResult;
                    JsonValue peopleResult;
                    JsonValue denseCaptionResult;
                    JsonValue objectsResult2;
                    int i;
                    JsonValue values;
                    JsonValue tagsResult2;
                    this.modelVersion = resultRoot.get("modelVersion").asString();
                    if (resultRoot.hasValue("metadata")) {
                        JsonValue metadata = resultRoot.get("metadata");
                        this.imageHeight = metadata.get("height").asInt();
                        this.imageWidth = metadata.get("width").asInt();
                    }
                    if (resultRoot.hasValue("tagsResult") && (tagsResult2 = resultRoot.get("tagsResult")).hasValue("values")) {
                        values = tagsResult2.get("values");
                        for (i = 0; i < values.count(); ++i) {
                            ContentTag tag = this.createContentTag(values.get(i));
                            this.tags.add(tag);
                        }
                    }
                    if (resultRoot.hasValue("objectsResult") && (objectsResult2 = resultRoot.get("objectsResult")).hasValue("values")) {
                        values = objectsResult2.get("values");
                        for (i = 0; i < values.count(); ++i) {
                            DetectedObject object = this.createDetectedObject(values.get(i));
                            this.detectedObjects.add(object);
                        }
                    }
                    if (resultRoot.hasValue("captionResult")) {
                        JsonValue captionResult = resultRoot.get("captionResult");
                        this.caption = this.createContentCaption(captionResult);
                    }
                    if (resultRoot.hasValue("denseCaptionsResult") && (denseCaptionResult = resultRoot.get("denseCaptionsResult")).hasValue("values")) {
                        values = denseCaptionResult.get("values");
                        for (i = 0; i < values.count(); ++i) {
                            ContentCaption caption = this.createContentCaption(values.get(i));
                            this.denseCaptions.add(caption);
                        }
                    }
                    if (resultRoot.hasValue("peopleResult") && (peopleResult = resultRoot.get("peopleResult")).hasValue("values")) {
                        values = peopleResult.get("values");
                        for (i = 0; i < values.count(); ++i) {
                            DetectedPerson person = this.creaDetectedPerson(values.get(i));
                            this.detectedPeople.add(person);
                        }
                    }
                    if (resultRoot.hasValue("readResult")) {
                        JsonValue readResult = resultRoot.get("readResult");
                        JsonValue documentPage = readResult.get("pages").get(0);
                        JsonValue jsonLines = documentPage.get("lines");
                        for (int i2 = 0; i2 < jsonLines.count(); ++i2) {
                            String lineContent = jsonLines.get(i2).get("content").asString();
                            String jsonPolygon1 = jsonLines.get(i2).get("boundingBox").asJson();
                            ArrayList<Float> boundingPolygon1 = new ArrayList<Float>();
                            if (jsonPolygon1 != null) {
                                String commaSeparatedStringOfPolygon1 = jsonPolygon1.replace("[", "").replace("]", "");
                                for (String s : commaSeparatedStringOfPolygon1.split(",")) {
                                    boundingPolygon1.add(Float.valueOf(Float.parseFloat(s)));
                                }
                            }
                            int lineOffset = jsonLines.get(i2).get("spans").get(0).get("offset").asInt();
                            int lineLength = jsonLines.get(i2).get("spans").get(0).get("length").asInt();
                            JsonValue jsonWords = documentPage.get("words");
                            ArrayList<DetectedTextWord> words = new ArrayList<DetectedTextWord>();
                            for (int j = 0; j < jsonWords.count(); ++j) {
                                String wordContent = jsonWords.get(j).get("content").asString();
                                Float wordConfidence = Float.valueOf(jsonWords.get(j).get("confidence").asFloat());
                                String jsonPolygon2 = jsonLines.get(j).get("boundingBox").asJson();
                                ArrayList<Float> boundingPolygon2 = new ArrayList<Float>();
                                if (jsonPolygon2 != null) {
                                    String commaSeparatedStringOfPolygon2 = jsonPolygon2.replace("[", "").replace("]", "");
                                    for (String s : commaSeparatedStringOfPolygon2.split(",")) {
                                        boundingPolygon2.add(Float.valueOf(Float.parseFloat(s)));
                                    }
                                }
                                int wordOffset = jsonWords.get(j).get("span").get("offset").asInt();
                                int wordLength = jsonWords.get(j).get("span").get("length").asInt();
                                if (wordOffset < lineOffset || wordOffset + wordLength > lineOffset + lineLength) continue;
                                DetectedTextWord word = new DetectedTextWord(wordContent, wordConfidence, boundingPolygon2);
                                words.add(word);
                            }
                            DetectedTextLine line = new DetectedTextLine(lineContent, boundingPolygon1, words);
                            this.detectedText.add(line);
                        }
                    }
                    if (resultRoot.hasValue("smartCropsResult") && (cropResult = resultRoot.get("smartCropsResult")).hasValue("values")) {
                        values = cropResult.get("values");
                        for (int i3 = 0; i3 < values.count(); ++i3) {
                            CropSuggestion cropSuggestion = this.createCropSuggestion(values.get(i3));
                            this.cropSuggestions.add(cropSuggestion);
                        }
                    }
                    if (!resultRoot.hasValue("customModelResult")) break block37;
                    JsonValue customModelResult = resultRoot.get("customModelResult");
                    if (customModelResult.hasValue("tagsResult") && (tagsResult = customModelResult.get("tagsResult")).hasValue("values")) {
                        JsonValue values2 = tagsResult.get("values");
                        for (int i4 = 0; i4 < values2.count(); ++i4) {
                            ContentTag tag = this.createContentTag(values2.get(i4));
                            this.customTags.add(tag);
                        }
                    }
                    if (customModelResult.hasValue("objectsResult") && (objectsResult = customModelResult.get("objectsResult")).hasValue("values")) {
                        JsonValue values3 = objectsResult.get("values");
                        for (int i5 = 0; i5 < values3.count(); ++i5) {
                            DetectedObject object = this.createDetectedObject(values3.get(i5));
                            this.customObjects.add(object);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (this.getReason() == ImageAnalysisResultReason.ANALYZED && this.jsonResult.isEmpty()) {
                try {
                    int width = Integer.parseInt(this.propertyCollection.getProperty("result.segmentation.image.width", "0"));
                    int height = Integer.parseInt(this.propertyCollection.getProperty("result.segmentation.image.height", "0"));
                    byte[] responseImage = this.propertyCollection.getPropertyBinary("result.segmentation.image.buffer");
                    if (responseImage != null && responseImage.length > 0) {
                        this.segmentationResult = new SegmentationResult(responseImage, responseImage.length, height, width);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (this.propertyCollection != null) {
            this.propertyCollection.close();
            this.propertyCollection = null;
        }
        if (this.resultHandle != null) {
            this.resultHandle.close();
            this.resultHandle = null;
        }
    }

    public final ImageAnalysisResultReason getReason() {
        int reason = Integer.parseInt(this.propertyCollection.getProperty("result.reason", "1"));
        return ImageAnalysisResultReason.values()[reason - 1];
    }

    public final String getModelVersion() {
        return this.modelVersion;
    }

    public final int getImageHeight() {
        return this.imageHeight;
    }

    public final int getImageWidth() {
        return this.imageWidth;
    }

    public final ContentCaption getCaption() {
        return this.caption;
    }

    public final List<ContentCaption> getDenseCaptions() {
        return this.denseCaptions;
    }

    public final List<ContentTag> getTags() {
        return this.tags;
    }

    public final List<ContentTag> getCustomTags() {
        return this.customTags;
    }

    public final List<DetectedObject> getObjects() {
        return this.detectedObjects;
    }

    public final List<DetectedObject> getCustomObjects() {
        return this.customObjects;
    }

    public final List<DetectedPerson> getPeople() {
        return this.detectedPeople;
    }

    public final List<DetectedTextLine> getText() {
        return this.detectedText;
    }

    public final List<CropSuggestion> getCropSuggestions() {
        return this.cropSuggestions;
    }

    public final SegmentationResult getSegmentationResult() {
        return this.segmentationResult;
    }

    public final PropertyCollection getProperties() {
        return this.propertyCollection;
    }

    public String toString() {
        return "ImageAnalysisResult{imageHeight=" + this.imageHeight + ", imageWidth=" + this.imageWidth + ", caption=" + this.caption + ", denseCaptions=" + this.denseCaptions + ", tags=" + this.tags + ", customTags=" + this.customTags + ", detectedObjects=" + this.detectedObjects + ", customObjects=" + this.customObjects + ", detectedPeople=" + this.detectedPeople + ", detectedText=" + this.detectedText + ", cropSuggestions=" + this.cropSuggestions + ", segmentationResult=" + this.segmentationResult + '}';
    }

    private BoundingBox createBoundingBox(JsonValue boundingBox) {
        int x = boundingBox.get("x").asInt();
        int y = boundingBox.get("y").asInt();
        int w = boundingBox.get("w").asInt();
        int h = boundingBox.get("h").asInt();
        return new BoundingBox(x, y, w, h);
    }

    private ContentCaption createContentCaption(JsonValue captionResult) {
        Float confidence = Float.valueOf(captionResult.get("confidence").asFloat());
        String content = captionResult.get("text").asString();
        BoundingBox BoundingBox2 = new BoundingBox(0, 0, this.imageWidth, this.imageHeight);
        if (captionResult.hasValue("boundingBox")) {
            JsonValue boundingBox = captionResult.get("boundingBox");
            BoundingBox2 = this.createBoundingBox(boundingBox);
        }
        return new ContentCaption(content, confidence, BoundingBox2);
    }

    private ContentTag createContentTag(JsonValue tagResult) {
        Float confidence = Float.valueOf(tagResult.get("confidence").asFloat());
        String name = tagResult.get("name").asString();
        return new ContentTag(name, confidence);
    }

    private DetectedObject createDetectedObject(JsonValue objectResult) {
        String name = objectResult.get("tags").get(0).get("name").asString();
        Float confidence = Float.valueOf(objectResult.get("tags").get(0).get("confidence").asFloat());
        BoundingBox BoundingBox2 = this.createBoundingBox(objectResult.get("boundingBox"));
        return new DetectedObject(name, confidence, BoundingBox2);
    }

    private DetectedPerson creaDetectedPerson(JsonValue personResult) {
        Float confidence = Float.valueOf(personResult.get("confidence").asFloat());
        BoundingBox BoundingBox2 = this.createBoundingBox(personResult.get("boundingBox"));
        return new DetectedPerson(confidence, BoundingBox2);
    }

    private CropSuggestion createCropSuggestion(JsonValue cropResult) {
        Float aspectRatio = Float.valueOf(cropResult.get("aspectRatio").asFloat());
        BoundingBox BoundingBox2 = this.createBoundingBox(cropResult.get("boundingBox"));
        return new CropSuggestion(aspectRatio, BoundingBox2);
    }
}

