/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis;

import com.azure.ai.vision.common.PropertyCollection;
import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.imageanalysis.ImageAnalysisResult;

public final class ImageAnalysisResultDetails {
    private PropertyCollection propertyCollection;
    private String resultId;
    private String imageId;
    private String connectionUrl;
    private String jsonResult;

    ImageAnalysisResultDetails(ImageAnalysisResult result) {
        this.propertyCollection = result.getProperties();
        this.resultId = this.propertyCollection.getProperty("result.id", "");
        this.imageId = this.propertyCollection.getProperty("image.analysis.result.image.id", "");
        this.connectionUrl = this.propertyCollection.getProperty("service.connection.url", "");
        this.jsonResult = this.propertyCollection.getProperty("image.analysis.result.json", "");
    }

    public static ImageAnalysisResultDetails fromResult(ImageAnalysisResult result) {
        Contracts.throwIfNull((Object)result, (String)"result");
        return new ImageAnalysisResultDetails(result);
    }

    public final String getResultId() {
        return this.resultId;
    }

    public final String getImageId() {
        return this.imageId;
    }

    public final String getConnectionUrl() {
        return this.connectionUrl;
    }

    public final String getJsonResult() {
        return this.jsonResult;
    }

    public String toString() {
        return "ImageAnalysisResultDetails{resultId='" + this.resultId + '\'' + ", imageId='" + this.imageId + '\'' + ", connectionUrl='" + this.connectionUrl + '\'' + ", jsonResult='" + this.jsonResult + '\'' + '}';
    }
}

