/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis;

import com.azure.ai.vision.common.VisionServiceOptions;
import com.azure.ai.vision.common.VisionSource;
import com.azure.ai.vision.common.implementation.SessionUtils;
import com.azure.ai.vision.common.internal.implementation.Contracts;
import com.azure.ai.vision.common.internal.implementation.EventSource;
import com.azure.ai.vision.common.internal.implementation.PropertiesJNI;
import com.azure.ai.vision.common.internal.implementation.SafeHandle;
import com.azure.ai.vision.common.internal.implementation.VisionEventArgsJNI;
import com.azure.ai.vision.common.internal.implementation.VisionSessionJNI;
import com.azure.ai.vision.imageanalysis.ImageAnalysisEventArgs;
import com.azure.ai.vision.imageanalysis.ImageAnalysisOptions;
import com.azure.ai.vision.imageanalysis.ImageAnalysisResult;
import com.azure.core.http.HttpClient;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class ImageAnalyzer
implements AutoCloseable {
    private AtomicInteger eventCounter = new AtomicInteger(0);
    public final EventSource<ImageAnalysisEventArgs> analyzed = new EventSource(this.eventCounter);
    private HttpClient httpClient;
    private static Set<ImageAnalyzer> imageAnalyzerObjects = Collections.synchronizedSet(new HashSet());
    private SafeHandle sessionHandle;
    private SafeHandle analyzeHandle;
    private boolean disposed = false;
    private boolean isStarted = false;
    private final Object analyzerLock = new Object();
    private int activeAsyncRecognitionCounter = 0;

    public ImageAnalyzer(VisionServiceOptions serviceOptions, VisionSource source, ImageAnalysisOptions analysisOptions) {
        Contracts.throwIfNull((Object)serviceOptions, (String)"serviceOptions");
        try (SafeHandle propHandle = PropertiesJNI.createPropertiesHandle();){
            HttpClient client;
            if (serviceOptions != null) {
                PropertiesJNI.copyProperties((SafeHandle)serviceOptions.getAdvanced().getProperties().getHandle(), (SafeHandle)propHandle, (String)"");
            }
            if (analysisOptions != null) {
                PropertiesJNI.copyProperties((SafeHandle)analysisOptions.getProperties().getHandle(), (SafeHandle)propHandle, (String)"");
            }
            HttpClient httpClient = client = serviceOptions != null ? serviceOptions.getAdvanced().getHttpClient() : null;
            if (client == null) {
                client = HttpClient.createDefault();
            }
            this.httpClient = client;
            PropertiesJNI.setPropertyString((SafeHandle)propHandle, (int)0, (String)"service.transport.type", (String)"binding");
            this.sessionHandle = VisionSessionJNI.createSessionHandle((SafeHandle)propHandle, (SafeHandle)(source == null ? null : source.getHandle()));
            this.analyzeHandle = VisionSessionJNI.createSessionViewHandle((SafeHandle)this.sessionHandle, (String)"image.analyzer", (SafeHandle)propHandle);
            final ImageAnalyzer _this = this;
            imageAnalyzerObjects.add(_this);
            VisionSessionJNI.sessionViewEventCallbackSet((Object)_this, (SafeHandle)this.sessionHandle, (String)"service.transport.http.request");
            this.analyzed.updateNotificationOnConnected(new Runnable(){

                @Override
                public void run() {
                    VisionSessionJNI.sessionViewEventCallbackSet((Object)_this, (SafeHandle)ImageAnalyzer.this.analyzeHandle, (String)"recognized");
                }
            });
        }
    }

    public final ImageAnalysisResult analyze() {
        try (SafeHandle result = VisionSessionJNI.sessionViewSingleShotStart((SafeHandle)this.analyzeHandle, null);){
            ImageAnalysisResult imageAnalysisResult = new ImageAnalysisResult(result);
            return imageAnalysisResult;
        }
    }

    public final Mono<ImageAnalysisResult> analyzeAsync() {
        Mono resultMono = Mono.defer(() -> {
            try (SafeHandle result = VisionSessionJNI.sessionViewSingleShotStart((SafeHandle)this.analyzeHandle, null);){
                Mono mono = Mono.just((Object)new ImageAnalysisResult(result));
                return mono;
            }
        }).subscribeOn(Schedulers.boundedElastic()).cache();
        return resultMono.hasElement().flatMap(hasElement -> {
            if (hasElement.booleanValue()) {
                return resultMono;
            }
            return Mono.just((Object)((ImageAnalysisResult)resultMono.block()));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        Object object = this.analyzerLock;
        synchronized (object) {
            if (this.activeAsyncRecognitionCounter != 0) {
                throw new IllegalStateException("Cannot dispose a analyzer while async analysis is running. Await async analysis to avoid unexpected disposals.");
            }
            if (this.disposed) {
                return;
            }
            if (this.analyzeHandle != null) {
                this.analyzeHandle.close();
                this.analyzeHandle = null;
            }
            if (this.sessionHandle != null) {
                this.sessionHandle.close();
                this.sessionHandle = null;
            }
            imageAnalyzerObjects.clear();
            this.disposed = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void eventDispatcher(String eventName, long eventArgs) {
        Contracts.throwIfNull((Object)this, (String)"recognizer");
        Contracts.throwIfNull((Object)eventName, (String)"eventName");
        try (SafeHandle eventArg = new SafeHandle(eventArgs, VisionEventArgsJNI::releaseVisionEventArgsHandle);){
            if (this.disposed) {
                return;
            }
            switch (eventName) {
                case "recognized": {
                    ImageAnalysisEventArgs resultEventArg = new ImageAnalysisEventArgs(eventArg);
                    EventSource<ImageAnalysisEventArgs> source = this.analyzed;
                    if (source == null) return;
                    source.fireEvent((Object)this, (Object)resultEventArg);
                    return;
                }
                case "service.transport.http.request": {
                    SessionUtils.SendHttpRequest((SafeHandle)eventArg, (HttpClient)this.httpClient);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncAnalyzeAction(Runnable action) {
        Object object = this.analyzerLock;
        synchronized (object) {
            ++this.activeAsyncRecognitionCounter;
        }
        if (this.disposed) {
            throw new IllegalStateException(this.getClass().getName());
        }
        try {
            action.run();
        }
        finally {
            object = this.analyzerLock;
            synchronized (object) {
                --this.activeAsyncRecognitionCounter;
            }
        }
    }
}

