/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis.implementation;

import com.azure.ai.vision.common.implementation.NativeLibraryLoader;
import com.azure.ai.vision.common.internal.implementation.VisionSessionJNI;
import com.azure.ai.vision.imageanalysis.ImageAnalysisOptions;

public final class ImageNativeLibraryLoader
extends NativeLibraryLoader {
    private static Boolean loaded = false;
    private NativeLibraryLoader.NativeLibrary[] nativeList = new NativeLibraryLoader.NativeLibrary[0];

    public void loadNativeBinding() throws UnsatisfiedLinkError {
        try {
            if (!loaded.booleanValue()) {
                this.extractNativeLibraries();
                this.loadExtractedNativeLibraries();
                VisionSessionJNI.reloadExtension();
            }
        }
        catch (Exception e) {
            throw new UnsatisfiedLinkError(String.format("Could not extract/load all Vision SDK libraries because we encountered the following error: %s", e.getMessage()));
        }
        finally {
            loaded = true;
        }
    }

    private void extractNativeLibraries() throws Exception {
        for (NativeLibraryLoader.NativeLibrary library : this.nativeList = this.getResourceLines()) {
            String prefix = this.getResourcesPath();
            String path = prefix + library.getName();
            this.extractResourceFromPath(library, ImageAnalysisOptions.class.getResourceAsStream(path));
        }
    }

    private NativeLibraryLoader.NativeLibrary[] getResourceLines() throws UnsatisfiedLinkError {
        if (operatingSystem.contains("linux")) {
            return new NativeLibraryLoader.NativeLibrary[]{new NativeLibraryLoader.NativeLibrary((NativeLibraryLoader)this, "libAzure-AI-Vision-Extension-Image.so", true)};
        }
        if (operatingSystem.contains("windows")) {
            return new NativeLibraryLoader.NativeLibrary[]{new NativeLibraryLoader.NativeLibrary((NativeLibraryLoader)this, "Azure-AI-Vision-Extension-Image.dll", true)};
        }
        if (operatingSystem.contains("mac") || operatingSystem.contains("darwin")) {
            return new NativeLibraryLoader.NativeLibrary[]{new NativeLibraryLoader.NativeLibrary((NativeLibraryLoader)this, "libAzure-AI-Vision-Extension-Image.dylib", true)};
        }
        throw new UnsatisfiedLinkError(String.format("The Vision SDK doesn't currently have native support for operating system: %s", operatingSystem));
    }
}

