/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis;

import com.azure.ai.vision.imageanalysis.ImageAnalysisClientBuilder;
import com.azure.ai.vision.imageanalysis.implementation.ImageAnalysisClientImpl;
import com.azure.ai.vision.imageanalysis.implementation.models.ImageUrl;
import com.azure.ai.vision.imageanalysis.models.ImageAnalysisOptions;
import com.azure.ai.vision.imageanalysis.models.ImageAnalysisResult;
import com.azure.ai.vision.imageanalysis.models.VisualFeatures;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ServiceClient(builder=ImageAnalysisClientBuilder.class)
public final class ImageAnalysisClient {
    private final ImageAnalysisClientImpl serviceClient;

    ImageAnalysisClient(ImageAnalysisClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> analyzeFromUrlWithResponse(List<String> visualFeatures, BinaryData imageUrl, RequestOptions requestOptions) {
        return this.serviceClient.analyzeFromUrlWithResponse(visualFeatures, imageUrl, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    ImageAnalysisResult analyzeFromUrl(List<VisualFeatures> visualFeatures, ImageUrl imageUrl, String language, Boolean genderNeutralCaption, List<Double> smartCropsAspectRatios, String modelVersion) {
        RequestOptions requestOptions = new RequestOptions();
        if (language != null) {
            requestOptions.addQueryParam("language", language, false);
        }
        if (genderNeutralCaption != null) {
            requestOptions.addQueryParam("gender-neutral-caption", String.valueOf(genderNeutralCaption), false);
        }
        if (smartCropsAspectRatios != null) {
            requestOptions.addQueryParam("smartcrops-aspect-ratios", JacksonAdapter.createDefaultSerializerAdapter().serializeIterable(smartCropsAspectRatios, CollectionFormat.CSV), false);
        }
        if (modelVersion != null) {
            requestOptions.addQueryParam("model-version", modelVersion, false);
        }
        return (ImageAnalysisResult)((BinaryData)this.analyzeFromUrlWithResponse(visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.toList()), BinaryData.fromObject((Object)imageUrl), requestOptions).getValue()).toObject(ImageAnalysisResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    ImageAnalysisResult analyzeFromUrl(List<VisualFeatures> visualFeatures, ImageUrl imageUrl) {
        RequestOptions requestOptions = new RequestOptions();
        return (ImageAnalysisResult)((BinaryData)this.analyzeFromUrlWithResponse(visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.toList()), BinaryData.fromObject((Object)imageUrl), requestOptions).getValue()).toObject(ImageAnalysisResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> analyzeFromImageDataWithResponse(List<String> visualFeatures, BinaryData imageData, RequestOptions requestOptions) {
        return this.serviceClient.analyzeFromImageDataWithResponse(visualFeatures, imageData, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    ImageAnalysisResult analyzeFromImageData(List<VisualFeatures> visualFeatures, BinaryData imageData, String language, Boolean genderNeutralCaption, List<Double> smartCropsAspectRatios, String modelVersion) {
        RequestOptions requestOptions = new RequestOptions();
        if (language != null) {
            requestOptions.addQueryParam("language", language, false);
        }
        if (genderNeutralCaption != null) {
            requestOptions.addQueryParam("gender-neutral-caption", String.valueOf(genderNeutralCaption), false);
        }
        if (smartCropsAspectRatios != null) {
            requestOptions.addQueryParam("smartcrops-aspect-ratios", JacksonAdapter.createDefaultSerializerAdapter().serializeIterable(smartCropsAspectRatios, CollectionFormat.CSV), false);
        }
        if (modelVersion != null) {
            requestOptions.addQueryParam("model-version", modelVersion, false);
        }
        return (ImageAnalysisResult)((BinaryData)this.analyzeFromImageDataWithResponse(visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.toList()), imageData, requestOptions).getValue()).toObject(ImageAnalysisResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    ImageAnalysisResult analyzeFromImageData(List<VisualFeatures> visualFeatures, BinaryData imageData) {
        RequestOptions requestOptions = new RequestOptions();
        return (ImageAnalysisResult)((BinaryData)this.analyzeFromImageDataWithResponse(visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.toList()), imageData, requestOptions).getValue()).toObject(ImageAnalysisResult.class);
    }

    static RequestOptions updateRequestOptions(RequestOptions inputRequestOptions, ImageAnalysisOptions imageAnalysisOptions) {
        RequestOptions outputRequestOptions = inputRequestOptions;
        if (imageAnalysisOptions != null) {
            String language = imageAnalysisOptions.getLanguage();
            Boolean isGenderNeutralCaption = imageAnalysisOptions.isGenderNeutralCaption();
            List<Double> smartCropsAspectRatios = imageAnalysisOptions.getSmartCropsAspectRatios();
            String modelVersion = imageAnalysisOptions.getModelVersion();
            if (language != null || isGenderNeutralCaption != null || smartCropsAspectRatios != null || modelVersion != null) {
                if (outputRequestOptions == null) {
                    outputRequestOptions = new RequestOptions();
                }
                if (language != null) {
                    outputRequestOptions.addQueryParam("language", language, false);
                }
                if (isGenderNeutralCaption != null) {
                    outputRequestOptions.addQueryParam("gender-neutral-caption", String.valueOf(isGenderNeutralCaption), false);
                }
                if (smartCropsAspectRatios != null) {
                    outputRequestOptions.addQueryParam("smartcrops-aspect-ratios", JacksonAdapter.createDefaultSerializerAdapter().serializeIterable(smartCropsAspectRatios, CollectionFormat.CSV), false);
                }
                if (modelVersion != null) {
                    outputRequestOptions.addQueryParam("model-version", modelVersion, false);
                }
            }
        }
        return outputRequestOptions;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ImageAnalysisResult analyzeFromUrl(String imageUrl, List<VisualFeatures> visualFeatures, ImageAnalysisOptions options) {
        return (ImageAnalysisResult)this.analyzeFromUrlWithResponse(imageUrl, visualFeatures, options, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ImageAnalysisResult analyze(BinaryData imageData, List<VisualFeatures> visualFeatures, ImageAnalysisOptions options) {
        return (ImageAnalysisResult)this.analyzeWithResponse(imageData, visualFeatures, options, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ImageAnalysisResult> analyzeFromUrlWithResponse(String imageUrl, List<VisualFeatures> visualFeatures, ImageAnalysisOptions imageAnalysisOptions, RequestOptions requestOptions) {
        List<String> visualFeaturesAsStrings = visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.toList());
        Response<BinaryData> response = this.analyzeFromUrlWithResponse(visualFeaturesAsStrings, BinaryData.fromObject((Object)new ImageUrl(imageUrl)), ImageAnalysisClient.updateRequestOptions(requestOptions, imageAnalysisOptions));
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)((ImageAnalysisResult)((BinaryData)response.getValue()).toObject(ImageAnalysisResult.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ImageAnalysisResult> analyzeWithResponse(BinaryData imageData, List<VisualFeatures> visualFeatures, ImageAnalysisOptions imageAnalysisOptions, RequestOptions requestOptions) {
        List<String> visualFeaturesAsStrings = visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.toList());
        Response<BinaryData> response = this.analyzeFromImageDataWithResponse(visualFeaturesAsStrings, imageData, ImageAnalysisClient.updateRequestOptions(requestOptions, imageAnalysisOptions));
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)((ImageAnalysisResult)((BinaryData)response.getValue()).toObject(ImageAnalysisResult.class)));
    }
}

