/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis.models;

import com.azure.ai.vision.imageanalysis.models.ImageBoundingBox;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CropRegion
implements JsonSerializable<CropRegion> {
    private final double aspectRatio;
    private final ImageBoundingBox boundingBox;

    private CropRegion(double aspectRatio, ImageBoundingBox boundingBox) {
        this.aspectRatio = aspectRatio;
        this.boundingBox = boundingBox;
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public ImageBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("aspectRatio", this.aspectRatio);
        jsonWriter.writeJsonField("boundingBox", (JsonSerializable)this.boundingBox);
        return jsonWriter.writeEndObject();
    }

    public static CropRegion fromJson(JsonReader jsonReader) throws IOException {
        return (CropRegion)jsonReader.readObject(reader -> {
            double aspectRatio = 0.0;
            ImageBoundingBox boundingBox = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("aspectRatio".equals(fieldName)) {
                    aspectRatio = reader.getDouble();
                    continue;
                }
                if ("boundingBox".equals(fieldName)) {
                    boundingBox = ImageBoundingBox.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new CropRegion(aspectRatio, boundingBox);
        });
    }
}

