/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis.models;

import com.azure.ai.vision.imageanalysis.models.ImageBoundingBox;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DenseCaption
implements JsonSerializable<DenseCaption> {
    private final double confidence;
    private final String text;
    private final ImageBoundingBox boundingBox;

    private DenseCaption(double confidence, String text, ImageBoundingBox boundingBox) {
        this.confidence = confidence;
        this.text = text;
        this.boundingBox = boundingBox;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public String getText() {
        return this.text;
    }

    public ImageBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("confidence", this.confidence);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeJsonField("boundingBox", (JsonSerializable)this.boundingBox);
        return jsonWriter.writeEndObject();
    }

    public static DenseCaption fromJson(JsonReader jsonReader) throws IOException {
        return (DenseCaption)jsonReader.readObject(reader -> {
            double confidence = 0.0;
            String text = null;
            ImageBoundingBox boundingBox = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("boundingBox".equals(fieldName)) {
                    boundingBox = ImageBoundingBox.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new DenseCaption(confidence, text, boundingBox);
        });
    }
}

