/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis.models;

import com.azure.ai.vision.imageanalysis.models.DetectedTag;
import com.azure.ai.vision.imageanalysis.models.ImageBoundingBox;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DetectedObject
implements JsonSerializable<DetectedObject> {
    private final ImageBoundingBox boundingBox;
    private final List<DetectedTag> tags;

    private DetectedObject(ImageBoundingBox boundingBox, List<DetectedTag> tags) {
        this.boundingBox = boundingBox;
        this.tags = tags;
    }

    public ImageBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public List<DetectedTag> getTags() {
        return this.tags;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("boundingBox", (JsonSerializable)this.boundingBox);
        jsonWriter.writeArrayField("tags", this.tags, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DetectedObject fromJson(JsonReader jsonReader) throws IOException {
        return (DetectedObject)jsonReader.readObject(reader -> {
            ImageBoundingBox boundingBox = null;
            List tags = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("boundingBox".equals(fieldName)) {
                    boundingBox = ImageBoundingBox.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readArray(reader1 -> DetectedTag.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new DetectedObject(boundingBox, tags);
        });
    }
}

