/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DetectedTag
implements JsonSerializable<DetectedTag> {
    private final double confidence;
    private final String name;

    private DetectedTag(double confidence, String name) {
        this.confidence = confidence;
        this.name = name;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public String getName() {
        return this.name;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("confidence", this.confidence);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static DetectedTag fromJson(JsonReader jsonReader) throws IOException {
        return (DetectedTag)jsonReader.readObject(reader -> {
            double confidence = 0.0;
            String name = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new DetectedTag(confidence, name);
        });
    }
}

